<?php

namespace App\Http\Middleware; // Ensure this namespace is correct

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Symfony\Component\HttpFoundation\Response;

class IsAdminMiddleware // Ensure this class name is correct
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        // Check if a user is logged in AND if they have an admin role ('admin' or 'super_admin')
        // by calling the isAdmin() method on the User model.
        if (Auth::check() && Auth::user()->isAdmin()) {
            return $next($request); // User is admin, proceed
        }

        // If not authenticated or not an admin:
        // Option 1: Redirect to the login page (standard for protected routes)
        // return redirect()->route('login');

        // Option 2: Redirect to the user dashboard with an error message
        // return redirect('/dashboard')->with('error', 'You do not have admin access.');

        // Option 3: Abort with a 403 Forbidden error
        abort(403, 'Unauthorized action. You do not have permission to access the admin panel.');
    }
}
