<?php

namespace App\Http\Livewire; // Or App\Livewire; if that's your configured directory

use Illuminate\Support\Facades\Auth;
use Livewire\Component;
use Illuminate\Support\Facades\Route; // Import Route facade

class NavigationMenu extends Component
{
    /**
     * The component's listeners.
     *
     * @var array
     */
    protected $listeners = [
        'refresh-navigation-menu' => '$refresh',
    ];

    /**
     * Render the component.
     *
     * @return \Illuminate\View\View
     */
    public function render()
    {
        $unreadNotificationsCount = 0;
        $recentNotifications = collect();

        if (Auth::check()) {
            $user = Auth::user();
            $unreadNotificationsCount = $user->unreadNotifications()->count();
            $recentNotifications = $user->notifications()->latest()->take(5)->get(); // Get 5 most recent, read or unread
        }

        return view('navigation-menu', [
            'unreadNotificationsCount' => $unreadNotificationsCount,
            'recentNotifications' => $recentNotifications,
        ]);
    }
    /**
     * Log the current user out of the application.
     *
     * @return \Illuminate\Http\RedirectResponse
     */
    public function logout()
    {
        Auth::logout();

        session()->invalidate();
        session()->regenerateToken();

        return redirect('/'); // Or your desired redirect path after logout
    }
}