<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\ModulePermission;
use Nwidart\Modules\Facades\Module;

class CheckAdminModuleAccess
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @param  string  $moduleName  The Nwidart module name (case-sensitive as in module.json)
     * @return mixed
     */
    public function handle(Request $request, Closure $next, string $moduleName)
    {
        if (Auth::check()) {
            $user = Auth::user();

            if ($user->isSuperAdmin()) {
                return $next($request); // Super admins can access all modules
            }

            if ($user->hasRole('admin')) {
                $module = Module::find($moduleName);
                if ($module && $module->isEnabled()) {
                    $hasPermission = ModulePermission::where('role_name', 'admin')
                                                     ->where('module_name', $moduleName)
                                                     ->exists();
                    if ($hasPermission) {
                        return $next($request);
                    }
                }
            }
        }
        return abort(403, 'You do not have permission to access this module.');
    }
}