<?php

namespace App\Http\Controllers\User;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\WalletWithdrawalRequest; // Added

class WalletTransactionController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index()
    {
        if (function_exists('setting') && setting('wallet_system_enabled', '0') != '1') {
            return redirect()->route('dashboard')->with('error', 'Wallet system is currently disabled.');
        }
        $transactions = Auth::user()->walletTransactions()->paginate(15);
        $withdrawalRequests = Auth::user()->walletWithdrawalRequests()->latest()->paginate(10, ['*'], 'withdrawals_page'); // Paginate separately
        return view('user.wallet.history', compact('transactions', 'withdrawalRequests'));
    }
}