<?php

namespace App\Http\Controllers\User;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Log;
use Nwidart\Modules\Facades\Module;
use App\Helpers\UserAccessHelper; // Crucial import

class DashboardController extends Controller
{
    public function __construct()
    {
        $this->middleware(['auth', 'verified']);
    }

    public function index()
    {
        $currentUser = Auth::user();
        $userMenuItems = [];

        if (class_exists(Module::class) && $currentUser) {
            foreach (Module::allEnabled() as $module) {
                $moduleUserMenu = $module->get('user_menu');
                $moduleManifest = $module->json(); // Get the full manifest

                if (is_array($moduleUserMenu)) {
                    $itemsForThisModule = [];
                    foreach ($moduleUserMenu as $item) {
                        if (isset($item['title'], $item['route_name']) && Route::has($item['route_name'])) {
                            $canDisplayItem = false;

                            if (isset($item['associated_feature_key'])) {
                                $featureKey = $item['associated_feature_key'];
                                $featureIsInherentlyFree = false;

                                $moduleFeatures = $moduleManifest->get('features');
                                $featureDefinition = null;
                                if (is_array($moduleFeatures)) {
                                    foreach ($moduleFeatures as $fDef) {
                                        if (isset($fDef['key']) && $fDef['key'] === $featureKey) {
                                            $featureDefinition = $fDef;
                                            break;
                                        }
                                    }
                                }

                                if ($featureDefinition) {
                                    $moduleRequiresSubscription = $moduleManifest->get('requires_subscription', true);
                                    $featureSpecificRequiresSubscription = $featureDefinition['requires_subscription'] ?? $moduleRequiresSubscription;
                                    if ($featureSpecificRequiresSubscription === false) {
                                        $featureIsInherentlyFree = true;
                                    }
                                } else {
                                    Log::warning("Dashboard: Menu item '{$item['title']}' for module '{$module->getName()}' has associated_feature_key '{$featureKey}' not found in module definitions.");
                                }

                                if ($featureIsInherentlyFree) {
                                    $canDisplayItem = true;
                                } else {
                                    $canDisplayItem = UserAccessHelper::canAccessFeature($currentUser, $featureKey);
                                }
                            } else {
                                $canDisplayItem = true;
                            }

                            if ($canDisplayItem) {
                                $itemsForThisModule[] = $item;
                            }
                        }
                    }
                    if (!empty($itemsForThisModule)) {
                        $userMenuItems[$module->get('display_name', $module->getName())] = $itemsForThisModule;
                    }
                }
            }
        }
        
        return view('dashboard', compact('userMenuItems'));
    }
}