<?php

namespace App\Http\Controllers\User;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class CreditTransactionController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index()
    {
        if (function_exists('setting') && setting('credits_system_enabled', '0') != '1') {
            return redirect()->route('dashboard')->with('error', 'Credits system is currently disabled.');
        }
        $transactions = Auth::user()->creditTransactions()->paginate(15);
        return view('user.credits.history', compact('transactions'));
    }
}