<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\WalletTransaction;
use App\Models\User;
use Illuminate\Http\Request;

class AdminWalletTransactionController extends Controller
{
    public function __construct()
    {
        // Ensure only super admins can manage this
        $this->middleware(function ($request, $next) {
            if (!auth()->user()->isSuperAdmin()) {
                abort(403, 'Unauthorized action. Super admin access required.');
            }
            return $next($request);
        });
    }

    /**
     * Display a listing of the wallet transactions.
     */
    public function index(Request $request)
    {
        $query = WalletTransaction::with('user')->latest();

        if ($request->filled('search_user')) {
            $searchTerm = $request->search_user;
            $query->whereHas('user', function ($q) use ($searchTerm) {
                $q->where('name', 'like', "%{$searchTerm}%")
                  ->orWhere('email', 'like', "%{$searchTerm}%");
            });
        }

        if ($request->filled('type')) {
            $query->where('type', $request->type);
        }

        $walletTransactions = $query->paginate(25)->withQueryString();
        $transactionTypes = WalletTransaction::distinct()->pluck('type');


        return view('admin.wallet_transactions.index', compact('walletTransactions', 'transactionTypes'));
    }
}