<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\CreditTransaction;
use App\Models\User;
use Illuminate\Http\Request;

class AdminCreditTransactionController extends Controller
{
    public function __construct()
    {
        // Ensure only super admins can manage this
        // You might use a specific middleware like EnsureUserIsSuperAdminForManagement
        // or check the role directly.
        $this->middleware(function ($request, $next) {
            if (!auth()->user()->isSuperAdmin()) {
                abort(403, 'Unauthorized action. Super admin access required.');
            }
            return $next($request);
        });
    }

    /**
     * Display a listing of the credit transactions.
     */
    public function index(Request $request)
    {
        $query = CreditTransaction::with('user')->latest();

        if ($request->filled('search_user')) {
            $searchTerm = $request->search_user;
            $query->whereHas('user', function ($q) use ($searchTerm) {
                $q->where('name', 'like', "%{$searchTerm}%")
                  ->orWhere('email', 'like', "%{$searchTerm}%");
            });
        }

        if ($request->filled('type')) {
            $query->where('type', $request->type);
        }

        $creditTransactions = $query->paginate(25)->withQueryString();
        $transactionTypes = CreditTransaction::distinct()->pluck('type');

        return view('admin.credit_transactions.index', compact('creditTransactions', 'transactionTypes'));
    }
}