<?php

namespace App\Helpers;
use App\Models\User; // Import the User model

use Nwidart\Modules\Facades\Module;
use Illuminate\Support\Facades\Log;
use Nwidart\Modules\Module as NwidartModule;

class SidebarAccessHelper
{
    /**
     */
    public static function canDisplayInSidebar(?User $user, string $featureKey): bool
    {
        $moduleSystemName = self::getModuleSystemNameFromFeatureKey($featureKey);
        $module = $moduleSystemName ? Module::find($moduleSystemName) : null;

        if ($moduleSystemName && (!$module || !$module->isEnabled())) {
            return false;
        }

        $canAccess = UserAccessHelper::canAccessFeature($user, $featureKey);
        return $canAccess;
    }

    private static function getModuleSystemNameFromFeatureKey(string $featureKey): ?string
    {
        $parts = explode('_', $featureKey);
        if (count($parts) > 1) {
            $potentialModuleName = $parts[0];
            $module = Module::find($potentialModuleName);
            if ($module) return $module->getName();
        }
        return null;
    }

    private static function getFeatureDefinition(?NwidartModule $module, string $featureKey): ?array
    {
        if (!$module) return null;
        $definedModuleFeatures = $module->get('features', []);
        foreach ($definedModuleFeatures as $def) {
            if (isset($def['key']) && $def['key'] === $featureKey) {
                return $def;
            }
        }
        return null;
    }
}