<?php

use App\Models\Setting;
use Illuminate\Support\Facades\Cache;

if (!function_exists('setting')) {
    /**
     */
    function setting(string $key, mixed $default = null): mixed
    {
        try {
            return Setting::getValue($key, $default);
        } catch (\Exception $e) {
            return $default;
        }
    }
}

if (!function_exists('clear_settings_cache')) {
    /**
     */
    function clear_settings_cache(): void {
        try {
            $cacheStore = Cache::store(config('cache.default'));
            if ($cacheStore->getStore() instanceof \Illuminate\Contracts\Cache\TaggableStore) {
                $cacheStore->tags('settings')->flush();
            }
        } catch (\Exception $e) {
        }
    }
}

if (!function_exists('image_mime_type')) {
    /**
     */
    function image_mime_type(string $filePath): ?string
    {
        if (!file_exists($filePath) || !is_readable($filePath) || !@getimagesize($filePath)) {
            return null;
        }
        $imageInfo = getimagesize($filePath);
        return $imageInfo['mime'] ?? null;
    }
}