<?php

namespace Modules\ZimflowApi\Providers;

use Illuminate\Foundation\Support\Providers\RouteServiceProvider as ServiceProvider;
use Illuminate\Support\Facades\Route;

class RouteServiceProvider extends ServiceProvider
{
    protected string $name = 'ZimflowApi';

    /** @var string The module namespace to assume when generating URLs to actions. */
    protected string $moduleNamespace = 'Modules\ZimflowApi\Http\Controllers';

    /**
     * Called before routes are registered.
     *
     * Register any model bindings or pattern based filters.
     */
    public function boot(): void
    {
        parent::boot();
    }

    /**
     * Define the routes for the application.
     */
    public function map(): void
    {
        $this->mapAdminRoutes();
        $this->mapApiRoutes();
        $this->mapWebRoutes();
    }

    /**
     * Define the "admin" routes for the module.
     *
     * These routes are typically protected by admin-specific middleware.
     * They are prefixed with '/admin/zimflowapi' and named with 'admin.zimflowapi.'.
     */
    protected function mapAdminRoutes(): void
    {
        Route::middleware(['web', \App\Http\Middleware\IsAdminMiddleware::class])
             ->prefix('admin/' . strtolower($this->name)) // e.g., admin/zimflowapi
             ->name('admin.' . strtolower($this->name) . '.')     // e.g., admin.zimflowapi.
             // If your admin controllers are in an 'Admin' sub-namespace (e.g., Modules\ZimflowApi\Http\Controllers\Admin)
             // and you are NOT using full namespaces in your admin.php routes, uncomment the line below.
             // ->namespace($this->moduleNamespace . '\\Admin')
             ->group(module_path($this->name, '/routes/admin.php'));
    }

    /**
     * Define the "web" routes for the application.
     *
     * These routes all receive session state, CSRF protection, etc.
     */
    protected function mapWebRoutes(): void
    {
        Route::middleware('web') // Ensures the group call is valid and context is clear
            // ->namespace($this->moduleNamespace) // Uncomment if your web controllers are not fully namespaced
            ->group(module_path($this->name, '/routes/web.php'));
    }

    /**
     * Define the "api" routes for the application.
     *
     * These routes are typically stateless.
     */
    protected function mapApiRoutes(): void
    {
        Route::middleware('api')
            ->prefix('api') // Global API prefix
            ->name('api.')   // Global API route name prefix
            // ->namespace($this->moduleNamespace . '\\Api') // Uncomment if API controllers are in an 'Api' sub-namespace and not fully namespaced
            ->group(module_path($this->name, '/routes/api.php'));
    }
}
