<?php

use Illuminate\Support\Facades\Route;
use Modules\WebPilotAI\Http\Controllers\Admin\DashboardController;
use Modules\WebPilotAI\Http\Controllers\Admin\AIModelController;
use Modules\WebPilotAI\Http\Controllers\Admin\UserSiteController;
use Modules\WebPilotAI\Http\Controllers\Admin\AITemplateController;
use Modules\WebPilotAI\Http\Controllers\Admin\AIStylePresetController;
use Modules\WebPilotAI\Http\Controllers\Admin\ModuleSettingsController;

/*
|--------------------------------------------------------------------------
| WebPilotAI Admin Routes
|--------------------------------------------------------------------------
|
| Here is where you can register admin routes for your WebPilotAI module.
| These routes are loaded by the WebPilotAIServiceProvider within a group which
| is assigned the "web" middleware group, a '/admin/webpilotai' prefix,
| and the 'admin.webpilotai.' route name prefix.
|
*/

// Dashboard
Route::get('dashboard', [DashboardController::class, 'index'])->name('dashboard');

// AI Model Configuration
Route::resource('models', AIModelController::class)->except(['show']); // Assuming no show view for admin models list

// User Websites
Route::resource('user-sites', UserSiteController::class);
Route::post('user-sites/{user_site}/regenerate', [UserSiteController::class, 'regenerate'])->name('user-sites.regenerate');

// AI Templates
Route::resource('ai-templates', AITemplateController::class);

// AI Style Presets
Route::resource('ai-style-presets', AIStylePresetController::class);

// Module Settings
Route::get('settings', [ModuleSettingsController::class, 'index'])->name('settings.index');
Route::put('settings', [ModuleSettingsController::class, 'store'])->name('settings.update');

// You can add more admin-specific routes here if needed