@extends('layouts.app') {{-- Or your main user-facing layout --}}

@section('title', 'Website Details: ' . ($website->name ?: 'Untitled Website'))
@section('header_title', $website->name ?: 'Untitled Website') {{-- Or your layout's equivalent section --}}

@section('content')
<div class="container mx-auto px-4 py-8">
    <div class="max-w-4xl mx-auto bg-white dark:bg-gray-800 shadow-xl rounded-lg">
        <div class="p-6 md:p-8">
            <div class="flex flex-col md:flex-row justify-between items-start md:items-center mb-6">
                <h1 class="text-3xl font-bold text-gray-800 dark:text-white mb-3 md:mb-0">
                    {{ $website->name ?: 'Untitled Website' }}
                </h1>
                <div class="flex space-x-3" id="main-action-buttons">
                    <a href="{{ route('frontend.webpilotai.websites.edit', $website->id) }}" class="inline-flex items-center px-4 py-2 border border-transparent shadow-sm text-sm font-medium rounded-md text-white bg-indigo-600 hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
                        <i class="fas fa-edit mr-2"></i>Edit & Regenerate
                    </a>
                    <a id="download-zip-button" href="{{ $website->generated_content_path ? asset($website->generated_content_path) : '#' }}" download
                       class="inline-flex items-center px-4 py-2 border border-blue-500 shadow-sm text-sm font-medium rounded-md text-blue-700 bg-blue-100 hover:bg-blue-200 dark:text-blue-300 dark:bg-blue-700 dark:hover:bg-blue-600 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 {{ ($website->status === \Modules\WebPilotAI\Models\Website::STATUS_COMPLETED && $website->generated_content_path) ? '' : 'hidden' }}">
                        <i class="fas fa-download mr-2"></i>Download ZIP
                    </a>
                     <a id="deploy-hosting-button" href="{{ route('frontend.webpilotai.websites.deploy.form', $website->id) }}"
                       class="inline-flex items-center px-4 py-2 border border-teal-500 shadow-sm text-sm font-medium rounded-md text-teal-700 bg-teal-100 hover:bg-teal-200 dark:text-teal-300 dark:bg-teal-700 dark:hover:bg-teal-600 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-teal-500 {{ ($website->status === \Modules\WebPilotAI\Models\Website::STATUS_COMPLETED && $website->generated_content_path) ? '' : 'hidden' }}">
                        <i class="fas fa-rocket mr-2"></i>Deploy
                    </a>
                </div>
            </div>

            @include('webpilotai::user.partials._session_messages') {{-- Or your main app's session messages partial --}}
            @include('webpilotai::user.partials._validation_errors')

            {{-- Status and Core Details Card --}}
            <div id="website-status-container" class="bg-gray-50 dark:bg-gray-700/50 p-6 rounded-lg shadow mb-8">
                <h2 class="text-xl font-semibold text-gray-800 dark:text-white mb-4">Status & Details</h2>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-x-6 gap-y-4 text-sm">
                    <div>
                        <dt class="font-medium text-gray-500 dark:text-gray-400">Overall Status</dt>
                        <dd class="mt-1">
                            <span id="status-badge-display" class="px-3 py-1 inline-flex text-xs leading-5 font-semibold rounded-full
                                @if($website->status === \Modules\WebPilotAI\Models\Website::STATUS_COMPLETED) bg-green-100 text-green-800 dark:bg-green-700 dark:text-green-100
                                @elseif(in_array($website->status, [\Modules\WebPilotAI\Models\Website::STATUS_PENDING_GENERATION, \Modules\WebPilotAI\Models\Website::STATUS_GENERATING, \Modules\WebPilotAI\Models\Website::STATUS_PENDING_REGENERATION, \Modules\WebPilotAI\Models\Website::STATUS_DEPLOYING])) bg-yellow-100 text-yellow-800 dark:bg-yellow-700 dark:text-yellow-100
                                @elseif($website->status === \Modules\WebPilotAI\Models\Website::STATUS_FAILED || $website->status === \Modules\WebPilotAI\Models\Website::STATUS_DEPLOYMENT_FAILED) bg-red-100 text-red-800 dark:bg-red-700 dark:text-red-100
                                @elseif($website->status === \Modules\WebPilotAI\Models\Website::STATUS_DEPLOYED) bg-teal-100 text-teal-800 dark:bg-teal-700 dark:text-teal-100
                                @else bg-gray-100 text-gray-800 dark:bg-gray-600 dark:text-gray-200 @endif">
                                {{ Str::title(str_replace('_', ' ', $website->status)) }}
                            </span>
                        </dd>
                    </div>
                    <div>
                        <dt class="font-medium text-gray-500 dark:text-gray-400">Last Generated</dt>
                        <dd class="mt-1 text-gray-900 dark:text-gray-100" id="last-generated-display">{{ $website->last_generated_at ? $website->last_generated_at->format('M d, Y H:i A') : 'Never' }}</dd>
                    </div>
                    <div>
                        <dt class="font-medium text-gray-500 dark:text-gray-400">AI Model</dt>
                        <dd class="mt-1 text-gray-900 dark:text-gray-100" id="ai-model-display">{{ $website->aiModel?->name ?? 'N/A' }} ({{ $website->aiModel?->provider ?? 'N/A' }})</dd>
                    </div>
                    <div>
                        <dt class="font-medium text-gray-500 dark:text-gray-400">AI Template</dt>
                        <dd class="mt-1 text-gray-900 dark:text-gray-100">{{ $website->aiTemplate?->name ?? 'None Selected' }}</dd>
                    </div>
                    <div class="md:col-span-2">
                        <dt class="font-medium text-gray-500 dark:text-gray-400">AI Style Presets</dt>
                        <dd class="mt-1">
                            @forelse($website->aiStylePresets as $preset)
                                <span class="inline-block bg-gray-200 dark:bg-gray-600 rounded-full px-3 py-1 text-xs font-semibold text-gray-700 dark:text-gray-200 mr-2 mb-2">{{ $preset->name }}</span>
                            @empty
                                <span class="text-gray-900 dark:text-gray-100">None Selected</span>
                            @endforelse
                        </dd>
                    </div>
                </div>

                <div id="error-message-display" class="mt-4 p-4 bg-red-50 dark:bg-red-900/30 border border-red-200 dark:border-red-700/50 rounded-md text-sm text-red-700 dark:text-red-300 whitespace-pre-wrap {{ ($website->status === \Modules\WebPilotAI\Models\Website::STATUS_FAILED || $website->status === \Modules\WebPilotAI\Models\Website::STATUS_DEPLOYMENT_FAILED) && $website->generation_error ? '' : 'hidden' }}">
                    <strong class="font-semibold">Error:</strong> {{ $website->generation_error }}
                </div>

                <div id="deployment-details-display" class="mt-4 p-4 bg-blue-50 dark:bg-blue-900/30 border border-blue-200 dark:border-blue-700/50 rounded-md text-sm text-blue-700 dark:text-blue-300 {{ ($website->status === \Modules\WebPilotAI\Models\Website::STATUS_DEPLOYED && $website->deployment_details) ? '' : 'hidden' }}">
                    @if($website->status === \Modules\WebPilotAI\Models\Website::STATUS_DEPLOYED && $website->deployment_details)
                        <p><strong class="font-semibold">Last Deployed To:</strong> {{ $website->deployment_details['host'] ?? 'N/A' }}
                            @if(isset($website->deployment_details['type'])) (Type: {{ strtoupper($website->deployment_details['type']) }}) @endif
                        </p>
                        @if(isset($website->deployment_details['remote_path']))
                            <p><strong class="font-semibold">Remote Path:</strong> {{ $website->deployment_details['remote_path'] }}</p>
                        @endif
                        @if(isset($website->deployment_details['deployed_at']))
                            <p><strong class="font-semibold">Deployment Time:</strong> {{ \Carbon\Carbon::parse($website->deployment_details['deployed_at'])->format('M d, Y H:i A') }}</p>
                        @endif
                    @endif
                </div>
            </div>

            {{-- Description Prompt Card --}}
            <div class="bg-white dark:bg-gray-800 shadow-lg rounded-lg p-6 mb-8">
                <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-3">Description Prompt</h3>
                <div class="p-4 bg-gray-50 dark:bg-gray-700/50 rounded-md text-sm text-gray-700 dark:text-gray-300 whitespace-pre-wrap leading-relaxed">
                    {{ $website->description_prompt }}
                </div>
            </div>

            {{-- Defined Pages Card --}}
            @if($website->pages_structure && count($website->pages_structure) > 0)
            <div class="bg-white dark:bg-gray-800 shadow-lg rounded-lg p-6 mb-8">
                <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-3">Defined Pages</h3>
                <ul class="list-disc list-inside text-sm text-gray-700 dark:text-gray-300 space-y-1">
                    @foreach($website->pages_structure as $page)
                        <li>{{ $page['name'] ?? 'Unnamed Page' }} (<code class="text-xs bg-gray-200 dark:bg-gray-600 px-1 py-0.5 rounded">{{ $page['filename'] ?? 'N/A' }}</code>)</li>
                    @endforeach
                </ul>
            </div>
            @endif

            {{-- Uploaded Assets Card --}}
            @if($website->assets->isNotEmpty())
            <div class="bg-white dark:bg-gray-800 shadow-lg rounded-lg p-6 mb-8">
                <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-3">Uploaded Assets</h3>
                <div class="grid grid-cols-2 sm:grid-cols-3 md:grid-cols-4 lg:grid-cols-5 gap-4">
                    @foreach($website->assets as $asset)
                    <div class="asset-item border dark:border-gray-700 rounded-md overflow-hidden">
                        <a href="{{ asset('storage/' . $asset->path) }}" target="_blank" title="View {{ $asset->original_name }}">
                            <img src="{{ asset('storage/' . $asset->path) }}" alt="{{ $asset->original_name }}" class="w-full h-24 object-cover">
                        </a>
                        <div class="p-2">
                            <p class="text-xs text-gray-700 dark:text-gray-300 truncate" title="{{ $asset->original_name }}">{{ Str::limit($asset->original_name, 15) }}</p>
                            @if($asset->description)
                            <p class="text-xs text-gray-500 dark:text-gray-400 truncate" title="{{ $asset->description }}"><em>{{ Str::limit($asset->description, 20) }}</em></p>
                            @endif
                        </div>
                    </div>
                    @endforeach
                </div>
            </div>
            @endif

            <div class="mt-8 pt-6 border-t border-gray-200 dark:border-gray-700 flex justify-between items-center">
                <a href="{{ route('frontend.webpilotai.websites.index') }}" class="text-blue-600 hover:text-blue-800 dark:text-blue-400 dark:hover:text-blue-300 font-medium">
                    &larr; Back to My Websites
                </a>
                <form action="{{ route('frontend.webpilotai.websites.destroy', $website->id) }}" method="POST" onsubmit="return confirm('Are you sure you want to delete this website? This action cannot be undone.');">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="inline-flex items-center px-4 py-2 border border-transparent shadow-sm text-sm font-medium rounded-md text-white bg-red-600 hover:bg-red-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-red-500">
                        <i class="fas fa-trash-alt mr-2"></i>Delete Website
                    </button>
                </form>
            </div>
        </div>
    </div>
</div>

@endsection

@push('scripts')
    {{-- JavaScript will always be present to handle initial state and potential polling --}}
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            let refreshInterval = 5000; // 5 seconds
            let attempts = 0;
            let maxAttempts = 24; // Refresh for up to 2 minutes (24 * 5s = 120s)
            let initialStatus = "{{ $website->status }}";

            const statusBadgeDisplay = document.getElementById('status-badge-display');
            const errorMessageDisplay = document.getElementById('error-message-display');
            const lastGeneratedDisplay = document.getElementById('last-generated-display');
            const deploymentDetailsDisplay = document.getElementById('deployment-details-display');
            const downloadZipButton = document.getElementById('download-zip-button');
            const deployHostingButton = document.getElementById('deploy-hosting-button');

            function requestNotificationPermission() {
                if (!("Notification" in window)) {
                    console.log("This browser does not support desktop notification");
                } else if (Notification.permission === "granted") {
                    return;
                } else if (Notification.permission !== "denied") {
                    Notification.requestPermission().then(function (permission) {
                        if (permission === "granted") {
                            console.log("Notification permission granted.");
                        }
                    });
                }
            }

            function updateUI(data) {
                // Update status badge
                statusBadgeDisplay.className = 'px-3 py-1 inline-flex text-xs leading-5 font-semibold rounded-full'; // Reset base classes
                if (data.status === '{{ \Modules\WebPilotAI\Models\Website::STATUS_COMPLETED }}') {
                    statusBadgeDisplay.classList.add('bg-green-100', 'text-green-800', 'dark:bg-green-700', 'dark:text-green-100');
                } else if (['{{ \Modules\WebPilotAI\Models\Website::STATUS_PENDING_GENERATION }}', '{{ \Modules\WebPilotAI\Models\Website::STATUS_GENERATING }}', '{{ \Modules\WebPilotAI\Models\Website::STATUS_PENDING_REGENERATION }}', '{{ \Modules\WebPilotAI\Models\Website::STATUS_DEPLOYING }}'].includes(data.status)) {
                    statusBadgeDisplay.classList.add('bg-yellow-100', 'text-yellow-800', 'dark:bg-yellow-700', 'dark:text-yellow-100');
                } else if (data.status === '{{ \Modules\WebPilotAI\Models\Website::STATUS_FAILED }}' || data.status === '{{ \Modules\WebPilotAI\Models\Website::STATUS_DEPLOYMENT_FAILED }}') {
                    statusBadgeDisplay.classList.add('bg-red-100', 'text-red-800', 'dark:bg-red-700', 'dark:text-red-100');
                } else if (data.status === '{{ \Modules\WebPilotAI\Models\Website::STATUS_DEPLOYED }}') {
                    statusBadgeDisplay.classList.add('bg-teal-100', 'text-teal-800', 'dark:bg-teal-700', 'dark:text-teal-100');
                } else {
                    statusBadgeDisplay.classList.add('bg-gray-100', 'text-gray-800', 'dark:bg-gray-600', 'dark:text-gray-200');
                }
                statusBadgeDisplay.textContent = data.status_friendly;

                // Update error message
                if ((data.status === '{{ \Modules\WebPilotAI\Models\Website::STATUS_FAILED }}' || data.status === '{{ \Modules\WebPilotAI\Models\Website::STATUS_DEPLOYMENT_FAILED }}') && data.generation_error) {
                    errorMessageDisplay.innerHTML = '<strong class="font-semibold">Error:</strong> ' + data.generation_error;
                    errorMessageDisplay.classList.remove('hidden');
                } else {
                    errorMessageDisplay.classList.add('hidden');
                }

                // Update last generated
                lastGeneratedDisplay.textContent = data.last_generated_at;

                // Update deployment details
                if (data.status === '{{ \Modules\WebPilotAI\Models\Website::STATUS_DEPLOYED }}' && data.deployment_details) {
                    let detailsHtml = '<p><strong class="font-semibold">Last Deployed To:</strong> ' + (data.deployment_details.host || 'N/A');
                    if (data.deployment_details.type) {
                        detailsHtml += ' (Type: ' + data.deployment_details.type.toUpperCase() + ')';
                    }
                    detailsHtml += '</p>';
                    if (data.deployment_details.remote_path) {
                        detailsHtml += '<p><strong class="font-semibold">Remote Path:</strong> ' + data.deployment_details.remote_path + '</p>';
                    }
                    if (data.deployment_details.deployed_at) {
                        let deployedDate = new Date(data.deployment_details.deployed_at).toLocaleString('en-US', { month: 'short', day: 'numeric', year: 'numeric', hour: '2-digit', minute: '2-digit', hour12: true });
                        detailsHtml += '<p><strong class="font-semibold">Deployment Time:</strong> ' + deployedDate + '</p>';
                    }
                    deploymentDetailsDisplay.innerHTML = detailsHtml;
                    deploymentDetailsDisplay.classList.remove('hidden');
                } else {
                    deploymentDetailsDisplay.innerHTML = '';
                    deploymentDetailsDisplay.classList.add('hidden');
                }

                // Update action buttons visibility
                downloadZipButton.classList.toggle('hidden', !data.can_download);
                if(data.can_download) downloadZipButton.href = data.generated_content_path;

                deployHostingButton.classList.toggle('hidden', !data.can_deploy_form);

                return data.status;
            }

            function checkStatus() {
                attempts++;
                if (attempts > maxAttempts) {
                    console.log('Max refresh attempts reached. Stopping auto-refresh.');
                    return;
                }
                fetch("{{ route('frontend.webpilotai.websites.status', $website->id) }}", {
                    headers: {
                        'X-Requested-With': 'XMLHttpRequest',
                        'Accept': 'application/json'
                    }
                })
                    .then(response => response.json())
                    .then(data => {
                        const currentStatus = updateUI(data);

                        if (currentStatus === '{{ \Modules\WebPilotAI\Models\Website::STATUS_GENERATING }}' || currentStatus === '{{ \Modules\WebPilotAI\Models\Website::STATUS_DEPLOYING }}' || currentStatus === '{{ \Modules\WebPilotAI\Models\Website::STATUS_PENDING_REGENERATION }}') {
                            setTimeout(checkStatus, refreshInterval);
                        } else {
                            console.log('Process finished. Status: ' + currentStatus);
                            if (Notification.permission === "granted") {
                                new Notification("WebPilotAI: " + data.name, { body: "Status updated to: " + data.status_friendly });
                            }
                        }
                    })
                    .catch(error => console.error('Error fetching website status:', error));
            }

            if (initialStatus === '{{ \Modules\WebPilotAI\Models\Website::STATUS_GENERATING }}' || initialStatus === '{{ \Modules\WebPilotAI\Models\Website::STATUS_DEPLOYING }}' || initialStatus === '{{ \Modules\WebPilotAI\Models\Website::STATUS_PENDING_REGENERATION }}') {
                setTimeout(checkStatus, refreshInterval);
            }
            requestNotificationPermission();
        });
    </script>
@endpush

@push('styles')
{{-- Font Awesome for icons if not already globally included --}}
{{-- <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css" /> --}}
@endpush
