@extends('layouts.app') {{-- Or your main user-facing layout --}}

@section('title', 'AI Content Writer')
@section('header_title', 'AI Content Writer')

@section('content')
<div class="container mx-auto px-4 py-8">
    <div class="mb-8 text-center">
        <h1 class="text-4xl font-bold text-gray-800 dark:text-white">AI Content Writer</h1>
        <p class="mt-2 text-lg text-gray-600 dark:text-gray-300">
            Craft compelling content for your website sections with the power of AI.
        </p>
    </div>

    @include('webpilotai::user.partials._session_messages')

    <div class="bg-white dark:bg-gray-800 shadow-xl rounded-lg p-6 md:p-8">
        <form id="contentWriterForm">
            @csrf
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
                <div>
                    <label for="ai_model_id" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">AI Model <span class="text-red-500">*</span></label>
                    <select name="ai_model_id" id="ai_model_id" required
                            class="mt-1 block w-full py-2 px-3 border border-gray-300 dark:border-gray-600 bg-white dark:bg-gray-700 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm dark:text-gray-200">
                        @if($aiModels->isEmpty())
                            <option value="">No AI models available</option>
                        @else
                            @foreach ($aiModels as $model)
                                <option value="{{ $model->id }}">{{ $model->name }} ({{ $model->provider }}) {{ $model->is_premium ? '[Premium]' : '' }}</option>
                            @endforeach
                        @endif
                    </select>
                </div>
                <div>
                    <label for="content_type" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Content Type <span class="text-red-500">*</span></label>
                    <select name="content_type" id="content_type" required
                            class="mt-1 block w-full py-2 px-3 border border-gray-300 dark:border-gray-600 bg-white dark:bg-gray-700 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm dark:text-gray-200">
                        @foreach ($contentTypes as $key => $label)
                            <option value="{{ $key }}">{{ $label }}</option>
                        @endforeach
                    </select>
                </div>
            </div>

            <div class="mb-6">
                <label for="topic" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Topic / Main Idea <span class="text-red-500">*</span></label>
                <textarea name="topic" id="topic" rows="3" required
                          class="mt-1 block w-full py-2 px-3 border border-gray-300 dark:border-gray-600 bg-white dark:bg-gray-700 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm dark:text-gray-200"
                          placeholder="e.g., Benefits of using renewable energy for small businesses"></textarea>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
                <div>
                    <label for="tone" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Desired Tone <span class="text-red-500">*</span></label>
                    <select name="tone" id="tone" required
                            class="mt-1 block w-full py-2 px-3 border border-gray-300 dark:border-gray-600 bg-white dark:bg-gray-700 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm dark:text-gray-200">
                        @foreach ($tones as $key => $label)
                            <option value="{{ $key }}">{{ $label }}</option>
                        @endforeach
                    </select>
                </div>
                <div>
                    <label for="length_preference" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Length Preference</label>
                    <select name="length_preference" id="length_preference"
                            class="mt-1 block w-full py-2 px-3 border border-gray-300 dark:border-gray-600 bg-white dark:bg-gray-700 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm dark:text-gray-200">
                        <option value="medium">Medium (Default)</option>
                        <option value="short">Short</option>
                        <option value="long">Long</option>
                    </select>
                </div>
            </div>

            <div class="mb-6">
                <label for="keywords" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Keywords (Optional, comma-separated)</label>
                <input type="text" name="keywords" id="keywords"
                       class="mt-1 block w-full py-2 px-3 border border-gray-300 dark:border-gray-600 bg-white dark:bg-gray-700 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm dark:text-gray-200"
                       placeholder="e.g., solar panels, cost saving, eco-friendly">
            </div>

            <div class="flex items-center justify-end">
                <button type="submit" id="generateButton"
                        class="inline-flex items-center justify-center px-6 py-3 border border-transparent text-base font-medium rounded-md shadow-sm text-white bg-indigo-600 hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500 dark:focus:ring-offset-gray-800">
                    <svg id="generateSpinner" class="animate-spin -ml-1 mr-3 h-5 w-5 text-white hidden" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                        <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                        <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                    </svg>
                    <span id="generateButtonText">Generate Content</span>
                </button>
            </div>
        </form>

        <div id="resultContainer" class="mt-8 hidden">
            <h3 class="text-xl font-semibold text-gray-800 dark:text-white mb-3">Generated Content:</h3>
            <div id="errorAlert" class="hidden p-4 mb-4 text-sm text-red-700 bg-red-100 rounded-lg dark:bg-red-200 dark:text-red-800" role="alert">
                <span class="font-medium">Error!</span> <span id="errorMessage"></span>
            </div>
            <textarea id="generatedText" rows="10" readonly
                      class="w-full p-3 border border-gray-300 dark:border-gray-600 bg-gray-50 dark:bg-gray-700 rounded-md shadow-sm sm:text-sm dark:text-gray-200 font-mono"></textarea>
            <button id="copyButton" class="mt-3 px-4 py-2 bg-blue-500 text-white text-sm font-medium rounded-md hover:bg-blue-600 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 dark:focus:ring-offset-gray-800">
                Copy to Clipboard
            </button>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function () {
    const form = document.getElementById('contentWriterForm');
    const generateButton = document.getElementById('generateButton');
    const generateButtonText = document.getElementById('generateButtonText');
    const spinner = document.getElementById('generateSpinner');
    const resultContainer = document.getElementById('resultContainer');
    const generatedTextarea = document.getElementById('generatedText');
    const copyButton = document.getElementById('copyButton');
    const errorAlert = document.getElementById('errorAlert');
    const errorMessage = document.getElementById('errorMessage');

    form.addEventListener('submit', function (e) {
        e.preventDefault();
        generateButton.disabled = true;
        spinner.classList.remove('hidden');
        generateButtonText.textContent = 'Generating...';
        resultContainer.classList.add('hidden');
        errorAlert.classList.add('hidden');

        const formData = new FormData(form);

        fetch('{{ route("frontend.webpilotai.contentwriter.generate") }}', {
            method: 'POST',
            body: formData,
            headers: {
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'), // If you have CSRF token meta tag
                'Accept': 'application/json',
            }
        })
        .then(response => response.json())
        .then(data => {
            resultContainer.classList.remove('hidden');
            if (data.success && data.text) {
                generatedTextarea.value = data.text;
            } else {
                errorMessage.textContent = data.error || 'An unknown error occurred.';
                errorAlert.classList.remove('hidden');
                generatedTextarea.value = ''; // Clear previous results on error
            }
        })
        .catch(error => {
            console.error('Error:', error);
            resultContainer.classList.remove('hidden');
            errorMessage.textContent = 'A network error occurred. Please try again.';
            errorAlert.classList.remove('hidden');
            generatedTextarea.value = '';
        })
        .finally(() => {
            generateButton.disabled = false;
            spinner.classList.add('hidden');
            generateButtonText.textContent = 'Generate Content';
        });
    });

    copyButton.addEventListener('click', function () {
        generatedTextarea.select();
        document.execCommand('copy');
        // Optional: Show a "Copied!" message
        const originalText = copyButton.textContent;
        copyButton.textContent = 'Copied!';
        setTimeout(() => {
            copyButton.textContent = originalText;
        }, 2000);
    });
});
</script>
@endpush