@extends('layouts.frontend')

@section('title', 'AI Website Templates - WebPilot AI')
@section('meta_description', 'Browse our library of professionally designed AI website templates. Find the perfect starting point for your next project with WebPilot AI.')
@section('meta_keywords', 'ai website templates, website designs, webpilot ai templates, professional templates')

@section('content')
<div class="py-12 md:py-20 bg-white dark:bg-gray-800">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8">
        <header class="text-center mb-12 md:mb-16">
            <h1 class="text-4xl sm:text-5xl font-extrabold text-gray-800 dark:text-white leading-tight">
                Explore Our AI Templates
            </h1>
            <p class="mt-6 text-lg sm:text-xl text-gray-600 dark:text-gray-300 max-w-2xl mx-auto">
                Kickstart your website with our diverse collection of AI-crafted templates.
            </p>
        </header>

        @if($aiTemplates->isEmpty())
            <div class="text-center py-12">
                <svg xmlns="http://www.w3.org/2000/svg" class="mx-auto h-16 w-16 text-gray-400 dark:text-gray-500" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="1">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M19.5 14.25v-2.625a3.375 3.375 0 00-3.375-3.375h-1.5A1.125 1.125 0 0113.5 7.125v-1.5a3.375 3.375 0 00-3.375-3.375H8.25m0 12.75h7.5m-7.5 3H12M10.5 2.25H5.625c-.621 0-1.125.504-1.125 1.125v17.25c0 .621.504 1.125 1.125 1.125h12.75c.621 0 1.125-.504 1.125-1.125V11.25a9 9 0 00-9-9z" />
                </svg>
                <h3 class="mt-2 text-xl font-medium text-gray-900 dark:text-white">No Templates Available Yet</h3>
                <p class="mt-1 text-sm text-gray-500 dark:text-gray-400">We're constantly adding new templates. Please check back soon!</p>
            </div>
        @else
            <div class="grid sm:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 gap-8">
                @foreach($aiTemplates as $template)
                    <div class="bg-slate-50 dark:bg-slate-700 rounded-lg shadow-lg overflow-hidden group transform hover:scale-105 transition-transform duration-300">
                        <a href="{{ route('register') }}?template={{ $template->slug }}"> {{-- Or a dedicated template preview page if you build one --}}
                            @if($template->preview_image_path)
                                <img src="{{ Storage::url($template->preview_image_path) }}" alt="{{ $template->name }}" class="w-full h-48 object-cover">
                            @else
                                <div class="w-full h-48 bg-gray-300 dark:bg-gray-600 flex items-center justify-center">
                                    <svg class="w-16 h-16 text-gray-400 dark:text-gray-500" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"></path></svg>
                                </div>
                            @endif
                            <div class="p-6">
                                <h3 class="text-xl font-semibold text-gray-800 dark:text-white mb-2">{{ $template->name }}</h3>
                                <p class="text-sm text-gray-600 dark:text-gray-400 mb-3 truncate">{{ Str::limit($template->description, 80) }}</p>
                                @if($template->is_premium)
                                    <span class="inline-block bg-purple-100 text-purple-700 dark:bg-purple-700 dark:text-purple-200 text-xs font-semibold px-2.5 py-0.5 rounded-full">Premium</span>
                                @endif
                                <div class="mt-4 text-center">
                                     <span class="inline-block bg-blue-500 group-hover:bg-blue-600 text-white text-sm font-medium py-2 px-5 rounded-lg transition-colors">
                                        Use Template
                                    </span>
                                </div>
                            </div>
                        </a>
                    </div>
                @endforeach
            </div>

            <div class="mt-12">
                {{ $aiTemplates->links() }}
            </div>
        @endif
    </div>
</div>
@endsection