<section class="py-16 md:py-24 bg-slate-50 dark:bg-slate-900">
    <div class="container mx-auto px-4">
        <div class="text-center mb-16">
            <h2 class="text-3xl sm:text-4xl font-bold text-gray-800 dark:text-white">Quick Answers</h2>
            <p class="mt-4 text-lg text-gray-600 dark:text-gray-300 max-w-xl mx-auto">Got questions? We've got answers.</p>
        </div>
        <div class="max-w-3xl mx-auto space-y-6">
            {{-- FAQ Item 1 --}}
            <div x-data="{ open: false }" class="bg-white dark:bg-gray-800 shadow-lg rounded-lg">
                <button @click="open = !open" class="flex justify-between items-center w-full p-6 text-left">
                    <span class="text-lg font-semibold text-gray-700 dark:text-white">Do I need coding skills?</span>
                    <svg :class="{'transform rotate-180': open}" class="w-6 h-6 text-gray-500 dark:text-gray-400 transition-transform duration-300" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path></svg>
                </button>
                <div x-show="open" x-collapse class="p-6 pt-0 text-gray-600 dark:text-gray-300">
                    <p>Not at all! WebPilot AI is designed for everyone. Our AI and visual editor handle all the technical heavy lifting.</p>
                </div>
            </div>
            {{-- FAQ Item 2 --}}
            <div x-data="{ open: false }" class="bg-white dark:bg-gray-800 shadow-lg rounded-lg">
                <button @click="open = !open" class="flex justify-between items-center w-full p-6 text-left">
                    <span class="text-lg font-semibold text-gray-700 dark:text-white">Can I use my own domain?</span>
                    <svg :class="{'transform rotate-180': open}" class="w-6 h-6 text-gray-500 dark:text-gray-400 transition-transform duration-300" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path></svg>
                </button>
                <div x-show="open" x-collapse class="p-6 pt-0 text-gray-600 dark:text-gray-300">
                    <p>Yes! You can easily download your website and host it anywhere, or use our direct deployment options for cPanel, FTP, and SFTP.</p>
                </div>
            </div>
             {{-- FAQ Item 3 --}}
            <div x-data="{ open: false }" class="bg-white dark:bg-gray-800 shadow-lg rounded-lg">
                <button @click="open = !open" class="flex justify-between items-center w-full p-6 text-left">
                    <span class="text-lg font-semibold text-gray-700 dark:text-white">How long does it take to build a website?</span>
                    <svg :class="{'transform rotate-180': open}" class="w-6 h-6 text-gray-500 dark:text-gray-400 transition-transform duration-300" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path></svg>
                </button>
                <div x-show="open" x-collapse class="p-6 pt-0 text-gray-600 dark:text-gray-300">
                    <p>With WebPilot AI, you can have a first draft of your website generated in minutes. Customization time depends on your specific needs, but our tools are designed for speed and efficiency.</p>
                </div>
            </div>
        </div>
        <div class="text-center mt-12">
            <a href="{{ route('public.faq') }}" class="text-blue-600 dark:text-blue-400 hover:text-blue-700 dark:hover:text-blue-500 font-semibold transition-colors duration-300">
                More Questions? Visit our FAQ &rarr;
            </a>
        </div>
    </div>
</section>
