@extends('layouts.frontend')

@section('title', 'Pricing Plans - WebPilot AI Website Builder')
@section('meta_description', 'Choose the perfect WebPilot AI plan for your needs. Explore our flexible pricing options for individuals, businesses, and agencies.')
@section('meta_keywords', 'webpilot ai pricing, ai website builder cost, subscription plans, website builder packages')

@section('content')
<div class="py-12 md:py-20 bg-white dark:bg-gray-800">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8">
        <header class="text-center mb-16">
            <h1 class="text-4xl sm:text-5xl font-extrabold text-gray-800 dark:text-white leading-tight">
                Simple, Transparent Pricing
            </h1>
            <p class="mt-6 text-lg sm:text-xl text-gray-600 dark:text-gray-300 max-w-2xl mx-auto">
                Find the perfect plan to unlock the full potential of AI-powered website creation.
            </p>
        </header>

        {{-- Pricing Table --}}
        @if($subscriptionPlans->isEmpty())
            <div class="text-center py-12">
                <svg xmlns="http://www.w3.org/2000/svg" class="mx-auto h-16 w-16 text-gray-400 dark:text-gray-500" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="1">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                </svg>
                <h3 class="mt-2 text-xl font-medium text-gray-900 dark:text-white">No Pricing Plans Available</h3>
                <p class="mt-1 text-sm text-gray-500 dark:text-gray-400">We are currently updating our pricing. Please check back soon!</p>
            </div>
        @else
            @php
                $numPlans = $subscriptionPlans->count();
                $gridClasses = 'grid-cols-1'; // Default: 1 column on small screens
                if ($numPlans >= 2) {
                    $gridClasses .= ' md:grid-cols-2'; // 2 columns on medium screens if 2+ plans
                }
                if ($numPlans >= 3) {
                    $gridClasses .= ' lg:grid-cols-3'; // 3 columns on large screens if 3+ plans
                }
            @endphp
            <div class="grid {{ $gridClasses }} gap-6 md:gap-8 max-w-7xl mx-auto">
                @foreach($subscriptionPlans as $plan)
                @php
                    $isPopular = (bool) $plan->is_popular;
                    $cardClasses = $isPopular
                        ? 'bg-blue-600 dark:bg-blue-700 text-white ring-2 ring-blue-500 dark:ring-blue-600 transform scale-105 hover:shadow-2xl' // Popular plan already scaled
                        : 'bg-slate-50 dark:bg-slate-700 border border-slate-200 dark:border-slate-600 hover:scale-[1.02] hover:shadow-2xl'; // Non-popular plan hover effect

                    $buttonClasses = $isPopular
                        ? 'bg-white hover:bg-blue-50 text-blue-600'
                        : ($plan->price == 0 ? 'bg-slate-200 dark:bg-slate-600 hover:bg-slate-300 dark:hover:bg-slate-500 text-gray-700 dark:text-white' : 'bg-blue-600 hover:bg-blue-700 text-white');

                    $planTitle = $plan->name;
                    if ($plan->target_role) {
                        $planTitle = Illuminate\Support\Str::title(str_replace('_', ' ', $plan->target_role)) . ' ' . $plan->name;
                    }
                    $planNameColor = $isPopular ? 'text-white' : ($plan->price == 0 ? 'text-blue-600 dark:text-blue-400' : ($isPopular ? 'text-white' : 'text-purple-600 dark:text-purple-400'));

                    $priceColor = $isPopular ? 'text-white' : 'text-gray-800 dark:text-white';
                    $featureTextColor = $isPopular ? 'opacity-90' : 'text-gray-600 dark:text-gray-300';
                    $featureIconColor = $isPopular ? 'text-green-300' : 'text-green-500';
                    $descriptionColor = $isPopular ? 'text-blue-100' : 'text-gray-500 dark:text-gray-400';
                    $initialFeaturesToShow = 5;
                @endphp
                <div x-data="{ showFeaturesModal: false }" class="{{ $cardClasses }} p-6 rounded-xl shadow-xl flex flex-col relative transition-all duration-300">
                    @if($isPopular)
                        <span class="absolute top-0 left-1/2 -translate-x-1/2 -translate-y-1/2 bg-yellow-400 text-yellow-900 px-3 py-1 text-sm font-semibold rounded-full shadow-md">Most Popular</span>
                    @endif
                    <div class="text-center">
                        <h3 class="text-2xl font-bold {{ $planNameColor }} mb-1">{{ $planTitle }}</h3>
                        <p class="text-4xl font-extrabold {{ $priceColor }} mb-2">
                            {{ $plan->currency_symbol ?? '$' }}{{ number_format($plan->price, 2) }}
                            <span class="text-base font-medium {{ $isPopular ? 'opacity-80' : 'text-gray-500 dark:text-gray-400' }}">
                                /{{ $plan->interval_count > 1 ? $plan->interval_count . ' ' : '' }}{{ Illuminate\Support\Str::ucfirst(Illuminate\Support\Str::plural($plan->interval, $plan->interval_count)) }}
                            </span>
                        </p>
                        <p class="text-sm {{ $descriptionColor }} mb-6 min-h-[40px] px-2">{{ $plan->description }}</p>
                    </div>

                    <div class="border-t {{ $isPopular ? 'border-blue-400 dark:border-blue-500' : 'border-gray-200 dark:border-gray-600' }} my-4"></div>

                    <div class="flex-grow mb-6">
                    @if($plan->features && count($plan->features) > 0)
                            <h4 class="text-sm font-semibold {{ $featureTextColor }} mb-2">Key Features:</h4>
                        <ul class="space-y-1.5 {{ $featureTextColor }} text-sm">
                            @foreach(collect($plan->features)->take($initialFeaturesToShow) as $featureItem)
                                @php
                                    $featureKey = $featureItem['key'];
                                    $featureLimit = $featureItem['limit'] ?? null;
                                    $featureDisplayName = Illuminate\Support\Str::title(str_replace(['_', '-'], ' ', $featureKey));

                                    // Attempt to find the feature's display name from module definitions
                                    foreach (($moduleDefinitions ?? []) as $moduleData) { // Added ?? [] for safety if undefined
                                        if (isset($moduleData['features'][$featureKey]['name'])) {
                                            $featureDisplayName = $moduleData['features'][$featureKey]['name'];
                                            break;
                                        }
                                    }
                                @endphp
                                <li class="flex items-start">
                                    <svg class="w-4 h-4 {{ $featureIconColor }} mr-2 mt-0.5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path></svg>
                                    {{ $featureDisplayName }}
                                    @if(!is_null($featureLimit))
                                        <span class="ml-1 text-xs {{ $isPopular ? 'opacity-70' : 'text-gray-400 dark:text-gray-500' }}">({{ $featureLimit == 0 ? 'Unlimited' : $featureLimit }})</span>
                                    @endif
                                </li>
                            @endforeach
                            @if(count($plan->features) > $initialFeaturesToShow)
                                <li class="mt-2">
                                    <button @click="showFeaturesModal = true" class="text-xs font-semibold {{ $isPopular ? 'text-blue-200 hover:text-white' : 'text-blue-500 hover:text-blue-700 dark:text-blue-400 dark:hover:text-blue-300' }} transition-colors duration-150">
                                        + {{ count($plan->features) - $initialFeaturesToShow }} more features (View all)
                                    </button>
                                </li>
                            @endif
                        </ul>
                    @else
                        <div class="min-h-[80px]"></div> {{-- Placeholder for consistent height if no features --}}
                    @endif
                    </div>

                    {{-- Credits Awarded --}}
                    @if($plan->credits_awarded_on_purchase > 0 || $plan->credits_awarded_on_renewal > 0)
                    <div class="mt-auto pt-3 border-t {{ $isPopular ? 'border-blue-400 dark:border-blue-500' : 'border-gray-200 dark:border-gray-600' }} text-sm {{ $featureTextColor }}">
                        <p class="font-semibold mb-1 text-xs uppercase tracking-wider">Credits Included:</p>
                        @if($plan->credits_awarded_on_purchase > 0)
                            <span class="block ml-2 text-xs">&bull; On Purchase: {{ number_format($plan->credits_awarded_on_purchase) }}</span>
                        @endif
                        @if($plan->credits_awarded_on_renewal > 0)
                            <span class="block ml-2 text-xs">&bull; On Renewal: {{ number_format($plan->credits_awarded_on_renewal) }}</span>
                        @endif
                    </div>
                    @endif

                    @if($plan->trial_period_days > 0)
                        <p class="text-xs text-center {{ $isPopular ? 'opacity-80' : 'text-gray-500 dark:text-gray-400' }} mb-3">{{ $plan->trial_period_days }}-day free trial available</p>
                    @endif

                    {{-- Link to registration with plan slug, or to subscription checkout if user is logged in --}}
                    <div class="mt-6"> {{-- Wrapper for CTA button --}}
                    @auth
                            <a href="{{ route('subscription.checkout', $plan->slug) }}" class="{{ $buttonClasses }} w-full block text-center font-semibold py-3 px-6 rounded-lg transition-colors duration-300">
                            Choose Plan
                        </a>
                    @else
                            <a href="{{ route('register', ['plan' => $plan->slug]) }}" class="{{ $buttonClasses }} w-full block text-center font-semibold py-3 px-6 rounded-lg transition-colors duration-300">
                            {{ $plan->price == 0 ? 'Get Started Free' : 'Sign Up' }}
                        </a>
                    @endauth
                </div>

                {{-- Features Modal --}}
                <div x-show="showFeaturesModal"
                     x-transition:enter="ease-out duration-300"
                     x-transition:enter-start="opacity-0"
                     x-transition:enter-end="opacity-100"
                     x-transition:leave="ease-in duration-200"
                     x-transition:leave-start="opacity-100"
                     x-transition:leave-end="opacity-0"
                     class="fixed inset-0 z-50 overflow-y-auto bg-black bg-opacity-75 flex items-center justify-center p-4"
                     @click.away="showFeaturesModal = false"
                     x-cloak
                >
                    <div class="bg-white dark:bg-gray-800 rounded-lg shadow-xl p-6 w-full max-w-md transform transition-all" @click.stop>
                        <div class="flex justify-between items-center mb-4">
                            <h4 class="text-xl font-semibold text-gray-800 dark:text-white">All Features for {{ $planTitle }}</h4>
                            <button @click="showFeaturesModal = false" class="text-gray-500 hover:text-gray-700 dark:text-gray-400 dark:hover:text-gray-200 transition-colors">
                                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path></svg>
                            </button>
                        </div>
                        <ul class="space-y-2 text-gray-600 dark:text-gray-300 max-h-[60vh] overflow-y-auto pr-2">
                            @foreach($plan->features as $featureItemModal)
                                @php
                                    $featureKeyModal = $featureItemModal['key'];
                                    $featureLimitModal = $featureItemModal['limit'] ?? null;
                                    $featureDisplayNameModal = Illuminate\Support\Str::title(str_replace(['_', '-'], ' ', $featureKeyModal));
                                    foreach (($moduleDefinitions ?? []) as $moduleDataModal) { // Added ?? [] for safety
                                        if (isset($moduleDataModal['features'][$featureKeyModal]['name'])) {
                                            $featureDisplayNameModal = $moduleDataModal['features'][$featureKeyModal]['name'];
                                            break;
                                        }
                                    }
                                @endphp
                                <li class="flex items-start py-1 border-b border-gray-200 dark:border-gray-700 last:border-b-0">
                                    <svg class="w-5 h-5 text-green-500 dark:text-green-400 mr-3 mt-0.5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path></svg>
                                    <span>
                                        {{ $featureDisplayNameModal }}
                                        @if(!is_null($featureLimitModal))
                                            <span class="ml-1 text-xs text-gray-400 dark:text-gray-500">({{ $featureLimitModal == 0 ? 'Unlimited' : $featureLimitModal }})</span>
                                        @endif
                                    </span>
                                </li>
                            @endforeach
                        </ul>
                    </div>
                </div> {{-- End of Modal Dialog --}}
                </div> {{-- End of Plan Card Div --}}
                @endforeach
            </div>
        @endif

        <div class="mt-16 text-center text-gray-600 dark:text-gray-400">
            <p>All plans include access to our intuitive visual editor, SEO assistant, and website version history.</p>
            <p>Need a custom solution? <a href="{{ route('frontend.contact.form') }}" class="text-blue-500 hover:underline">Get in touch</a> with us!</p>
        </div>
    </div>
</div>
@endsection