@extends('layouts.frontend')

@section('title', 'FAQ - WebPilot AI Website Builder')
@section('meta_description', 'Find answers to frequently asked questions about WebPilot AI. Learn more about our AI website builder, features, pricing, and support.')
@section('meta_keywords', 'webpilot ai faq, frequently asked questions, ai website help, support')

@section('content')
<div class="py-12 md:py-20 bg-slate-50 dark:bg-slate-900">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8">
        <header class="text-center mb-12 md:mb-16">
            <h1 class="text-4xl sm:text-5xl font-extrabold text-gray-800 dark:text-white leading-tight">
                Frequently Asked Questions
            </h1>
            <p class="mt-6 text-lg sm:text-xl text-gray-600 dark:text-gray-300 max-w-2xl mx-auto">
                Have questions? We've got answers. If you don't find what you're looking for, feel free to <a href="{{ route('frontend.contact.form') }}" class="text-blue-500 hover:underline">contact us</a>.
            </p>
        </header>

        <div class="max-w-3xl mx-auto space-y-8">
            {{-- FAQ Item 1 --}}
            <div x-data="{ open: false }" class="bg-white dark:bg-gray-800 shadow-lg rounded-lg">
                <button @click="open = !open" class="flex justify-between items-center w-full p-6 text-left">
                    <span class="text-lg font-semibold text-gray-700 dark:text-white">What is WebPilot AI?</span>
                    <svg :class="{'transform rotate-180': open}" class="w-6 h-6 text-gray-500 dark:text-gray-400 transition-transform duration-300" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path></svg>
                </button>
                <div x-show="open" x-collapse class="p-6 pt-0 text-gray-600 dark:text-gray-300">
                    <p>WebPilot AI is an innovative platform that uses artificial intelligence to help you design, build, and launch professional websites quickly and easily, without needing any coding skills.</p>
                </div>
            </div>

            {{-- FAQ Item 2 --}}
            <div x-data="{ open: false }" class="bg-white dark:bg-gray-800 shadow-lg rounded-lg">
                <button @click="open = !open" class="flex justify-between items-center w-full p-6 text-left">
                    <span class="text-lg font-semibold text-gray-700 dark:text-white">Do I need coding knowledge to use WebPilot AI?</span>
                    <svg :class="{'transform rotate-180': open}" class="w-6 h-6 text-gray-500 dark:text-gray-400 transition-transform duration-300" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path></svg>
                </button>
                <div x-show="open" x-collapse class="p-6 pt-0 text-gray-600 dark:text-gray-300">
                    <p>Absolutely not! WebPilot AI is designed for everyone. Our intuitive visual editor and AI-powered tools handle all the technical aspects, allowing you to focus on your content and design.</p>
                </div>
            </div>

            {{-- FAQ Item 3 --}}
            <div x-data="{ open: false }" class="bg-white dark:bg-gray-800 shadow-lg rounded-lg">
                <button @click="open = !open" class="flex justify-between items-center w-full p-6 text-left">
                    <span class="text-lg font-semibold text-gray-700 dark:text-white">Can I use my own domain name?</span>
                    <svg :class="{'transform rotate-180': open}" class="w-6 h-6 text-gray-500 dark:text-gray-400 transition-transform duration-300" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path></svg>
                </button>
                <div x-show="open" x-collapse class="p-6 pt-0 text-gray-600 dark:text-gray-300">
                    <p>Yes! While we may offer subdomain options, you can easily download your generated website as a ZIP file and upload it to any hosting provider to use with your custom domain name. We also offer direct deployment options to popular hosting platforms.</p>
                </div>
            </div>

            {{-- FAQ Item 4 --}}
            <div x-data="{ open: false }" class="bg-white dark:bg-gray-800 shadow-lg rounded-lg">
                <button @click="open = !open" class="flex justify-between items-center w-full p-6 text-left">
                    <span class="text-lg font-semibold text-gray-700 dark:text-white">What kind of support do you offer?</span>
                    <svg :class="{'transform rotate-180': open}" class="w-6 h-6 text-gray-500 dark:text-gray-400 transition-transform duration-300" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path></svg>
                </button>
                <div x-show="open" x-collapse class="p-6 pt-0 text-gray-600 dark:text-gray-300">
                    <p>We offer comprehensive support through our knowledge base, FAQs, and email support. Premium plan users also get access to priority support channels. Our goal is to ensure you have a smooth and successful experience.</p>
                </div>
            </div>

            {{-- Add more FAQ items as needed --}}

        </div>
    </div>
</div>
@endsection

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/@alpinejs/collapse@3.x.x/dist/cdn.min.js" defer></script>
@endpush