@extends('layouts.frontend')

@section('title', 'About Us - WebPilot AI Website Builder')
@section('meta_description', 'Learn about WebPilot AI, our mission to revolutionize web design with artificial intelligence, and the team behind our innovative website builder.')
@section('meta_keywords', 'about webpilot ai, ai website company, web design innovation, artificial intelligence team')

@section('content')
<div class="py-12 md:py-20 bg-white dark:bg-gray-800">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8">
        <header class="text-center mb-12 md:mb-16">
            <h1 class="text-4xl sm:text-5xl font-extrabold text-gray-800 dark:text-white leading-tight">
                About WebPilot AI
            </h1>
            <p class="mt-6 text-lg sm:text-xl text-gray-600 dark:text-gray-300 max-w-3xl mx-auto">
                We're passionate about empowering everyone to create beautiful, professional websites with the magic of AI.
            </p>
        </header>

        <div class="max-w-4xl mx-auto text-gray-700 dark:text-gray-300 space-y-8">
            <section>
                <h2 class="text-3xl font-semibold text-gray-800 dark:text-white mb-4">Our Mission</h2>
                <p class="text-lg leading-relaxed">
                    At WebPilot AI, our mission is to democratize web design. We believe that creating a stunning online presence shouldn't require technical expertise or a hefty budget. By harnessing the power of artificial intelligence, we provide intuitive tools that allow individuals, startups, and businesses of all sizes to build high-quality websites quickly and effortlessly.
                </p>
                <p class="text-lg leading-relaxed mt-4">
                    We are committed to continuous innovation, constantly exploring new AI capabilities to enhance our platform and deliver an unparalleled website building experience.
                </p>
            </section>

            <section>
                <h2 class="text-3xl font-semibold text-gray-800 dark:text-white mb-4">The Technology</h2>
                <p class="text-lg leading-relaxed">
                    WebPilot AI leverages state-of-the-art artificial intelligence models for design generation, content creation, and image sourcing. Our platform integrates various AI engines to understand your needs and translate them into a fully functional website. From choosing the right color palettes and font schemes to structuring content and suggesting visuals, our AI acts as your personal web design expert.
                </p>
            </section>

            {{-- You can add a "Our Team" section here if you like --}}
            {{-- <section>
                <h2 class="text-3xl font-semibold text-gray-800 dark:text-white mb-6 text-center">Meet the Innovators</h2>
                <div class="grid sm:grid-cols-2 lg:grid-cols-3 gap-8">
                    Team member cards
                </div>
            </section> --}}

            <section class="text-center mt-16">
                <h2 class="text-3xl font-semibold text-gray-800 dark:text-white mb-6">Ready to Build Your Future?</h2>
                <a href="{{ route('register') }}" class="bg-blue-600 hover:bg-blue-700 text-white font-bold py-4 px-10 rounded-lg text-xl shadow-lg hover:shadow-xl transition-all duration-300">
                    Start Your AI Website Today
                </a>
            </section>
        </div>
    </div>
</div>
@endsection