@extends('layouts.admin') {{-- Or your main admin layout --}}

@section('title', 'Edit AI Model')
@section('header_title', 'Edit AI Model: ' . $model->name) {{-- Use $model --}}

@section('content')
<div class="p-6">
    <div class="bg-white dark:bg-gray-800 shadow-md rounded-lg p-6">
        <h2 class="text-2xl font-semibold text-gray-700 dark:text-gray-200 mb-6">Update AI Model Details</h2>

        @include('webpilotai::admin.partials._validation_errors')

        <form action="{{ route('admin.webpilotai.models.update', $model->id) }}" method="POST"> {{-- Use $model --}}
            @csrf
            @method('PUT')

            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                {{-- Name --}}
                <div>
                    <label for="name" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Model Name <span class="text-red-500">*</span></label>
                    <input type="text" name="name" id="name" value="{{ old('name', $model->name) }}" required autocomplete="off"
                           class="mt-1 block w-full py-2 px-3 border border-gray-300 dark:border-gray-600 bg-white dark:bg-gray-700 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm dark:text-gray-200"
                           placeholder="e.g., GPT-4 Turbo">
                </div>

                {{-- Provider --}}
                <div>
                    <label for="provider" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Provider <span class="text-red-500">*</span></label>
                    <select name="provider" id="provider" required data-providers='@json($providersData)' autocomplete="off"
                            class="mt-1 block w-full py-2 px-3 border border-gray-300 dark:border-gray-600 bg-white dark:bg-gray-700 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm dark:text-gray-200">
                        <option value="">-- Select Provider --</option>
                        {{-- Options will be populated by JavaScript --}}
                        {{-- Add other providers as they become available/supported --}}
                    </select>
                </div>
            </div>

            {{-- Identifier --}}
            <div class="mt-6">
                <label for="identifier" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Model Identifier <span class="text-red-500">*</span></label>
                <select name="identifier" id="identifier" required autocomplete="off"
                       class="mt-1 block w-full py-2 px-3 border border-gray-300 dark:border-gray-600 bg-white dark:bg-gray-700 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm dark:text-gray-200"
                       disabled> {{-- Start disabled until provider is selected --}}
                    <option value="">-- Select Model Identifier --</option>
                    {{-- Options will be populated by JavaScript based on Provider selection --}}
                </select>
                <p class="mt-1 text-xs text-gray-500 dark:text-gray-400">The exact model ID used by the provider's API.</p>
            </div>

            {{-- API Key Setting Name --}}
            <div class="mt-6">
                <label for="api_key_setting_name" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">API Key Setting Name <span class="text-red-500">*</span></label>
                <select name="api_key_setting_name" id="api_key_setting_name" required autocomplete="off"
                       class="mt-1 block w-full py-2 px-3 border border-gray-300 dark:border-gray-600 bg-white dark:bg-gray-700 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm dark:text-gray-200"
                       >
                    <option value="">-- Select API Key Setting --</option>
                    @foreach($apiKeySettings as $key => $label)
                        <option value="{{ $key }}" {{ old('api_key_setting_name', $model->api_key_setting_name) == $key ? 'selected' : '' }}>{{ $label }} (Full Key: {{ $key }})</option> {{-- Use $model --}}
                    @endforeach
                </select>
                <p class="mt-1 text-xs text-gray-500 dark:text-gray-400">Select the setting that stores the API key for the chosen provider. The value saved will be the full key name (e.g., `webpilotai.openai_api_key`).</p>
            </div>

            {{-- Description --}}
            <div class="mt-6">
                <label for="description" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Description (Optional)</label>
                <textarea name="description" id="description" rows="3" autocomplete="off"
                          class="mt-1 block w-full py-2 px-3 border border-gray-300 dark:border-gray-600 bg-white dark:bg-gray-700 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm dark:text-gray-200"
                          placeholder="Briefly describe this model's capabilities or intended use.">{{ old('description', $model->description) }}</textarea> {{-- Corrected $odel to $model --}}
            </div>

            {{-- Flags --}}
            <div class="mt-6 grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <label for="is_active" class="flex items-center">
                        <input type="checkbox" name="is_active" id="is_active" value="1" {{ old('is_active', $model->is_active) ? 'checked' : '' }}
                               class="h-4 w-4 text-indigo-600 border-gray-300 dark:border-gray-600 rounded focus:ring-indigo-500 dark:bg-gray-700 dark:focus:ring-offset-gray-800">
                        <span class="ml-2 text-sm text-gray-700 dark:text-gray-300">Active (Available for users)</span>
                    </label>
                </div>
                <div>
                    <label for="is_premium" class="flex items-center">
                        <input type="checkbox" name="is_premium" id="is_premium" value="1" {{ old('is_premium', $model->is_premium) ? 'checked' : '' }}
                               class="h-4 w-4 text-indigo-600 border-gray-300 dark:border-gray-600 rounded focus:ring-indigo-500 dark:bg-gray-700 dark:focus:ring-offset-gray-800">
                        <span class="ml-2 text-sm text-gray-700 dark:text-gray-300">Premium (Requires subscription/permission)</span>
                    </label>
                </div>
            </div>

            {{-- Actions --}}
            <div class="mt-8 pt-5 border-t border-gray-200 dark:border-gray-700">
                <div class="flex justify-end">
                    <a href="{{ route('admin.webpilotai.models.index') }}" class="bg-gray-200 hover:bg-gray-300 text-gray-700 font-bold py-2 px-4 rounded-lg mr-3 transition duration-150 ease-in-out dark:bg-gray-600 dark:text-gray-200 dark:hover:bg-gray-500">
                        Cancel
                    </a>
                    <button type="submit" class="bg-green-500 hover:bg-green-600 text-white font-bold py-2 px-4 rounded-lg shadow-md transition duration-150 ease-in-out">
                        <i class="fas fa-save mr-2"></i> Update Model
                    </button>
                </div>
            </div>
        </form>
    </div>
</div>
@endsection

@push('styles')
{{-- Add any specific styles for this page here if needed --}}
@endpush

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function () {
    // --- Debugging Logs Start ---
    console.log('DOMContentLoaded fired for AI Model Edit');
    console.log('Passed providersData:', @json($providersData));
    console.log('Current Model Data:', @json($model)); // Log the current model data
    // --- Debugging Logs End ---

    const providerSelect = document.getElementById('provider');
    const identifierSelect = document.getElementById('identifier');
    const providersData = providerSelect.dataset.providers ? JSON.parse(providerSelect.dataset.providers) : {};

    // Function to populate the Provider dropdown
    function populateProviders() {
        // Clear existing options except the default
        // --- Debugging Logs Start ---
        console.log('Populating providers for Edit...');
        // --- Debugging Logs End ---
        providerSelect.innerHTML = '<option value="">-- Select Provider --</option>';
        for (const providerName in providersData) {
            const option = document.createElement('option');
            option.value = providerName;
            option.textContent = providerName;
            // Check if this provider was the old selected value on validation error or the current model's provider
            if ("{{ old('provider', $model->provider) }}" === providerName) { // Use $model
                option.selected = true;
                // --- Debugging Logs Start ---
                console.log('Selected initial provider (Edit):', providerName);
                // --- Debugging Logs End ---
            }
            providerSelect.appendChild(option);
        }
        // --- Debugging Logs Start ---
        console.log('Providers populated (Edit). Current providerSelect.value:', providerSelect.value);
        // --- Debugging Logs End ---
    }

    // Function to populate the Identifier dropdown based on selected Provider
    function populateIdentifiers(selectedProvider, selectedIdentifier = null) {
        // --- Debugging Logs Start ---
        console.log('Populating identifiers for provider (Edit):', selectedProvider, 'with selectedIdentifier:', selectedIdentifier);
        // --- Debugging Logs End ---
        identifierSelect.innerHTML = '<option value="">-- Select Model Identifier --</option>';
        if (selectedProvider && providersData[selectedProvider] && providersData[selectedProvider].identifiers) {
            providersData[selectedProvider].identifiers.forEach(identifier => {
                const option = document.createElement('option');
                option.value = identifier;
                option.textContent = identifier;
                // Select the old value on validation error or the passed selectedIdentifier
                if (("{{ old('identifier', $model->identifier) }}" === identifier) || (selectedIdentifier && selectedIdentifier === identifier)) { // Use $model
                     option.selected = true;
                }
                identifierSelect.appendChild(option);
            });
            identifierSelect.disabled = false;
        } else {
            identifierSelect.disabled = true; // Ensure it's disabled if no provider or no identifiers
            // --- Debugging Logs Start ---
            console.log('No identifiers found or provider not selected (Edit).');
            // --- Debugging Logs End ---
        }
    }

    // Event listener for Provider select change
    providerSelect.addEventListener('change', function() {
        // --- Debugging Logs Start ---
        console.log('Provider changed to (Edit):', this.value);
        // --- Debugging Logs End ---
        populateIdentifiers(this.value);
    });

    // Initial population and state setting
    populateProviders(); // Populate the provider dropdown first
    // Then populate identifiers based on the initially selected provider (either old input or model's provider)
    populateIdentifiers(providerSelect.value, "{{ old('identifier', $model->identifier) }}"); // Use $model
});
</script>
@endpush
