<?php

namespace Modules\WebPilotAI\Providers;

use Illuminate\Foundation\Support\Providers\RouteServiceProvider as ServiceProvider;
use Illuminate\Support\Facades\Route;

class RouteServiceProvider extends ServiceProvider
{
    protected string $name = 'WebPilotAI';
    /**
     * The controller namespace for the module. This is a common property in module service providers.
     */
    protected string $moduleNamespace = 'Modules\WebPilotAI\Http\Controllers';

    /**
     * Called before routes are registered.
     *
     * Register any model bindings or pattern based filters.
     */
    public function boot(): void
    {
        parent::boot();
    }

    /**
     * Define the routes for the application.
     */
    public function map(): void
    {
        $this->mapAdminRoutes(); // Add this line to register admin routes
        $this->mapApiRoutes();
        $this->mapWebRoutes();
    }

    /**
     * Define the "admin" routes for the application.
     *
     * These routes are loaded by this service provider.
     * They are prefixed with '/admin/webpilotai' and named with 'admin.webpilotai.'.
     * Middleware applied is consistent with the main application's admin routes.
     */
    protected function mapAdminRoutes(): void
    {
        Route::middleware(['web', \App\Http\Middleware\IsAdminMiddleware::class]) // Apply web middleware and your admin auth middleware
            ->prefix('admin/webpilotai') // URL prefix for module admin routes
            ->name('admin.webpilotai.')   // Route name prefix for module admin routes
            ->group(module_path($this->name, '/routes/admin.php'));
    }

    /**
     * Define the "web" routes for the application.
     *
     * These routes all receive session state, CSRF protection, etc.
     */
    protected function mapWebRoutes(): void
    {
        Route::middleware('web')
            // ->namespace($this->moduleNamespace) // Uncomment if your web controllers are not fully namespaced in routes/web.php
            ->group(module_path($this->name, '/routes/web.php'));
    }

    /**
     * Define the "api" routes for the application.
     *
     * These routes are typically stateless.
     */
    protected function mapApiRoutes(): void
    {
        Route::middleware('api')
            ->prefix('api') // This is the global /api prefix
            ->name('api.')   // This is the global api. name prefix
            // ->namespace($this->moduleNamespace) // Uncomment if your API controllers are not fully namespaced in routes/api.php
            ->group(module_path($this->name, '/routes/api.php'));
    }
}
