<?php

namespace Modules\WebPilotAI\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Modules\WebPilotAI\Models\AIModel;
use Modules\WebPilotAI\Models\Website;

class DashboardController extends Controller
{
    /**
     * Display the admin dashboard for WebPilotAI.
     */
    public function index()
    {
        $totalAIModels = AIModel::count();
        $activeAIModels = AIModel::where('is_active', true)->count();
        $totalWebsites = Website::count();
        $completedWebsites = Website::where('status', 'completed')->count();
        $pendingWebsites = Website::whereIn('status', ['pending_generation', 'generating', 'pending_regeneration'])->count();

        return view('webpilotai::admin.dashboard', compact(
            'totalAIModels', 'activeAIModels', 'totalWebsites', 'completedWebsites', 'pendingWebsites'
        ));
    }
}