<?php

namespace Modules\WebPilotAI\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Support\Str;

class AITemplate extends Model
{
    use HasFactory;

    protected $table = 'ai_templates';

    protected $fillable = [
        'name',
        'slug',
        'description',
        'preview_image_path',
        'category',
        'tags',
        'prompt_modifications',
        'is_premium',
        'is_active',
        'sort_order',
    ];

    protected $casts = [
        'tags' => 'array',
        'prompt_modifications' => 'array',
        'is_premium' => 'boolean',
        'is_active' => 'boolean',
    ];

    // Accessor for slug generation if needed, or handle in observer/controller
    // public function setNameAttribute($value) {
    //     $this->attributes['name'] = $value;
    //     if (!isset($this->attributes['slug']) || empty($this->attributes['slug'])) {
    //         $this->attributes['slug'] = Str::slug($value);
    //     }
    // }

    // If you create a factory:
    // protected static function newFactory()
    // {
    //     return \Modules\WebPilotAI\Database\factories\AITemplateFactory::new();
    // }
}