<?php

namespace Modules\WebPilotAI\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Support\Str;
use Illuminate\Database\Eloquent\Casts\AsArrayObject; // Keep this if you were using it
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
class AIStylePreset extends Model
{
    use HasFactory;

    protected $table = 'ai_style_presets';

    protected $fillable = [
        'name',
        'slug',
        'description',
        'type',
        'configuration',
        'preview_image_path',
        'is_premium',
        'is_active',
        'sort_order',
    ];

    protected $casts = [
        'configuration' => AsArrayObject::class, // Or 'array' if you prefer plain arrays
        'is_premium' => 'boolean',
        'is_active' => 'boolean',
    ];

    /**
     * The websites that belong to the AI style preset.
     */
    public function websites(): BelongsToMany
    {
        return $this->belongsToMany(Website::class, 'ai_style_preset_website', 'ai_style_preset_id', 'website_id')
                    ->withTimestamps(); // Assuming your pivot table has timestamps (if not, remove this line)
    }

    // If you create a factory:
    // protected static function newFactory()
    // {
    //     return \Modules\WebPilotAI\Database\factories\AIStylePresetFactory::new();
    // }
}