<?php

namespace Modules\WebPilotAI\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;
use Modules\WebPilotAI\Models\Website;

class WebsiteDeployedSuccessfully extends Mailable
{
    use Queueable, SerializesModels;

    public Website $website;

    /**
     * Create a new message instance.
     */
    public function __construct(Website $website)
    {
        $this->website = $website;
    }

    /**
     * Get the message envelope.
     */
    public function envelope(): Envelope
    {
        return new Envelope(
            subject: 'Deployment Successful for AI Website: "' . ($this->website->name ?: 'Untitled') . '"',
        );
    }

    /**
     * Get the message content definition.
     */
    public function content(): Content
    {
        return new Content(
            view: 'webpilotai::emails.deployment.success', // We'll create this Blade view next
        );
    }

    /**
     * Get the attachments for the message.
     *
     * @return array<int, \Illuminate\Mail\Mailables\Attachment>
     */
    public function attachments(): array
    {
        return [];
    }
}