<?php

namespace Modules\WebPilotAI\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Mail;
use Modules\WebPilotAI\Events\WebsiteDeploymentSucceeded;
use Modules\WebPilotAI\Mail\WebsiteDeployedSuccessfully;

class SendWebsiteDeploymentSuccessNotification implements ShouldQueue
{
    use InteractsWithQueue;

    /**
     * Create the event listener.
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     */
    public function handle(WebsiteDeploymentSucceeded $event): void
    {
        if ($event->website->user && $event->website->user->email) {
            Mail::to($event->website->user->email)
                ->send(new WebsiteDeployedSuccessfully($event->website));
            Log::info("Sent WebsiteDeploymentSucceeded email to {$event->website->user->email} for website ID: {$event->website->id}");
        } else {
            Log::warning("Could not send WebsiteDeploymentSucceeded email: User or user email missing for website ID: {$event->website->id}");
        }
    }
}