<?php

namespace Modules\WebPilotAI\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Mail;
use Modules\WebPilotAI\Events\WebsiteDeploymentFailed;
use Modules\WebPilotAI\Mail\WebsiteDeploymentHasFailed;

class SendWebsiteDeploymentFailureNotification implements ShouldQueue
{
    use InteractsWithQueue;

    /**
     * Create the event listener.
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     */
    public function handle(WebsiteDeploymentFailed $event): void
    {
        if ($event->website->user && $event->website->user->email) {
            Mail::to($event->website->user->email)
                ->send(new WebsiteDeploymentHasFailed($event->website, $event->errorMessage));
            Log::info("Sent WebsiteDeploymentFailed email to {$event->website->user->email} for website ID: {$event->website->id}");
        } else {
            Log::warning("Could not send WebsiteDeploymentFailed email: User or user email missing for website ID: {$event->website->id}");
        }
    }
}