<?php

namespace Modules\WebPilotAI\Http\Controllers\User;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;
use App\Models\Setting;
use Modules\WebPilotAI\Models\AITemplate; // Assuming you'll use this model

class TemplateController extends Controller
{
    /**
     * Display a listing of the AI templates.
     */
    public function index()
    {
        $user = Auth::user();
        $premiumAccessFeatureKey = 'webpilotai_premium_items_access'; // From your module.json
        $canAccessPremium = false;

        if ($user->currentSubscription() && $user->currentSubscription()->plan) {
            $planFeatures = $user->currentSubscription()->plan->features ?? [];
            foreach ($planFeatures as $feature) {
                if (isset($feature['key']) && $feature['key'] === $premiumAccessFeatureKey) {
                    $canAccessPremium = true;
                    break;
                }
            }
        }

        $aiTemplatesQuery = AITemplate::where('is_active', true);

        if (!$canAccessPremium) {
            $aiTemplatesQuery->where('is_premium', false);
        }

        $aiTemplates = $aiTemplatesQuery
            ->orderBy('sort_order') // Assuming you have a sort_order column
            ->orderBy('name')
            ->paginate(12); // Paginate for better UX

        return view('webpilotai::user.templates.index', compact('aiTemplates', 'canAccessPremium'));
    }
}