<?php

namespace Modules\WebPilotAI\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Modules\WebPilotAI\Models\AITemplate; // Assuming you'll use this model

class PublicTemplateController extends Controller
{
    /**
     * Display a public listing of AI templates.
     */
    public function index()
    {
        $aiTemplates = AITemplate::where('is_active', true)->where('is_premium', false)->orderBy('sort_order')->paginate(12);
        // You might want to add logic for premium templates if publicly viewable but marked differently
        return view('webpilotai::frontend.templates.public_index', compact('aiTemplates'));
    }
}