<?php

namespace Modules\WebPilotAI\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use App\Models\SubscriptionPlan; // Import SubscriptionPlan model
use Illuminate\Http\Request;
use Nwidart\Modules\Facades\Module; // Import Module facade

class PageController extends Controller
{
    /**
     * Display the features page.
     */
    public function features()
    {
        // Replace with your actual view and logic
        return view('webpilotai::frontend.pages.features');
    }

    /**
     * Display the pricing page.
     */
    public function pricing()
    {
        $subscriptionPlans = SubscriptionPlan::where('active', true)
            // Fetch all active plans. The target_role will be displayed on the card.
            ->orderBy('price') // Order by price, or a custom sort_order column if you add one.
            ->get();

        // Fetch module feature definitions to display user-friendly names
        $moduleDefinitions = [];
        if (class_exists(Module::class)) {
            foreach (Module::allEnabled() as $module) {
                $moduleName = $module->getName();
                $moduleDisplayName = $module->get('display_name', $moduleName);
                $definedFeatures = $module->get('features');

                if (is_array($definedFeatures) && !empty($definedFeatures)) {
                    $featuresForThisModuleDef = [];
                    foreach ($definedFeatures as $featureDef) {
                        $featuresForThisModuleDef[$featureDef['key']] = $featureDef;
                    }
                    $moduleDefinitions[$moduleName] = ['displayName' => $moduleDisplayName, 'features' => $featuresForThisModuleDef];
                }
            }
        }

        return view('webpilotai::frontend.pages.pricing', compact('subscriptionPlans', 'moduleDefinitions'));
    }

    /**
     * Display the about us page.
     */
    public function about()
    {
        // Replace with your actual view and logic
        return view('webpilotai::frontend.pages.about');
    }

    /**
     * Display the FAQ page.
     */
    public function faq()
    {
        // Replace with your actual view and logic
        return view('webpilotai::frontend.pages.faq');
    }
}