<?php

namespace Modules\WebPilotAI\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use App\Models\NewsletterSubscription; // Import the model
use Illuminate\Support\Str; // For generating tokens
use Illuminate\Http\Request;
use Illuminate\Http\RedirectResponse; // For redirect response

class NewsletterController extends Controller
{
    /**
     * Handle newsletter subscription.
     */
    public function subscribe(Request $request): RedirectResponse
    {
        $validated = $request->validate([
            'email' => 'required|email|max:255', // Remove unique rule here, handle logic below
        ]);

        $existingSubscription = NewsletterSubscription::where('email', $validated['email'])->first();

        if ($existingSubscription) {
            if ($existingSubscription->status === 'subscribed') {
                return back()->with('info', 'You are already subscribed to our newsletter.');
            } elseif ($existingSubscription->status === 'unsubscribed') {
                // Optionally, re-subscribe them or ask for confirmation
                // For simplicity, let's re-subscribe them and generate a new token.
                $existingSubscription->update([
                    'status' => 'subscribed',
                    'subscribed_at' => now(),
                    'unsubscribed_at' => null,
                    'token' => Str::random(32) // Generate a new token
                ]);
                return back()->with('success', 'You have been re-subscribed to our newsletter!');
            }
            // If status is 'pending', you might want to resend a confirmation or just inform them.
            return back()->with('info', 'Your subscription status is currently ' . $existingSubscription->status . '.');
        }

        NewsletterSubscription::create($validated + ['status' => 'subscribed']); // Default status, token and subscribed_at are handled by model boot

        return back()->with('success', 'Thank you for subscribing to our newsletter!');
    }
}