<?php

namespace Modules\WebPilotAI\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Modules\WebPilotAI\Models\AIModel;
use Modules\WebPilotAI\Models\Website;
use Modules\WebPilotAI\Models\AITemplate;
use Modules\WebPilotAI\Models\AIStylePreset;
use App\Models\Setting; // Import the Setting model

class DashboardController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $totalAIModels = AIModel::count();
        $activeAIModels = AIModel::where('is_active', true)->count();

        $totalWebsites = Website::count();
        $completedWebsites = Website::where('status', Website::STATUS_COMPLETED)->count();
        $pendingWebsites = Website::whereIn('status', [
            Website::STATUS_PENDING_GENERATION,
            Website::STATUS_GENERATING,
            Website::STATUS_PENDING_REGENERATION,
            Website::STATUS_DEPLOYING, // Added deploying as a pending state for dashboard
        ])->count();

        $totalAITemplates = AITemplate::count();
        $activeAITemplates = AITemplate::where('is_active', true)->count();

        $totalAIStylePresets = AIStylePreset::count();
        $activeAIStylePresets = AIStylePreset::where('is_active', true)->count();

        // Placeholder for Image Studio stats - replace with actual model count later
        $totalGeneratedImages = 0; // Example: UserGeneratedImage::count();
        $activeImageProviders = (int)Setting::getValue('webpilotai.enable_dalle_image_generation', false) + (int)Setting::getValue('webpilotai.enable_pexels_stock_photos', false);

        return view('webpilotai::admin.dashboard', compact(
            'totalAIModels', 'activeAIModels',
            'totalWebsites', 'completedWebsites', 'pendingWebsites',
            'totalAITemplates', 'activeAITemplates',
            'totalAIStylePresets', 'activeAIStylePresets',
            'totalGeneratedImages', 'activeImageProviders'
        ));
    }
}