<?php

namespace Modules\WebPilotAI\Events;

use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;
use Modules\WebPilotAI\Models\Website;

class WebsiteDeploymentFailed
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    public Website $website;
    public string $errorMessage;
    public bool $jobFailedPermanently;

    /**
     * Create a new event instance.
     *
     * @param Website $website
     * @param string $errorMessage
     * @param bool $jobFailedPermanently
     */
    public function __construct(Website $website, string $errorMessage, bool $jobFailedPermanently = false)
    {
        $this->website = $website;
        $this->errorMessage = $errorMessage;
        $this->jobFailedPermanently = $jobFailedPermanently;
    }

    // public function broadcastOn() { return []; }
}