<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Admin Routes
|--------------------------------------------------------------------------
|
| Here is where you can register admin routes for your module. These
| routes are loaded by the main application's RouteServiceProvider within
| a group which LIES WITHIN the "admin" prefix and "admin." naming
| convention.
|
*/

// The main app/Providers/RouteServiceProvider.php already applies the
// 'Modules\StripeGateway\Http\Controllers\Admin' namespace.
// Routes defined here will use that namespace.

// This route will be accessible via URL: admin/stripegateway/settings
// And named: admin.stripegateway.settings.edit
Route::get('settings', 'StripeConfigController@edit')->name('settings.edit');
Route::post('settings', 'StripeConfigController@update')->name('settings.update');

// Add other admin routes for StripeGateway here
// Example: Route::get('transactions', 'TransactionController@index')->name('transactions.index');
// This would be admin.stripegateway.transactions.index
