<?php

use Illuminate\Support\Facades\Route;
use Modules\PaystackGateway\Http\Controllers\PaystackSubscriptionController;
use Modules\PaystackGateway\Http\Controllers\PaystackWebhookController; // Add this

// Route::middleware(['auth', 'verified'])->group(function () {
//     Route::resource('paystackgateways', PaystackGatewayController::class)->names('paystackgateway');
// });

// Webhook - should generally be exempt from CSRF
Route::post('webhooks/paystack', [PaystackWebhookController::class, 'handleWebhook'])->name('webhooks.paystack.handle');

Route::middleware(['web', 'auth']) // User must be authenticated
     ->prefix('subscribe/paystack')
     ->name('subscription.paystack.')
     ->group(function () {
         // The {subscriptionPlan:slug} will use route model binding
         Route::get('initialize/{subscriptionPlan:slug}', [PaystackSubscriptionController::class, 'initializePayment'])
            ->name('initialize');
         Route::get('callback', [PaystackSubscriptionController::class, 'handleCallback'])->name('callback'); // Paystack callback
     });

Route::middleware(['web', 'auth'])
    ->prefix('wallet/paystack')
    ->name('wallet.paystack.')
    ->group(function () {
        // The WalletController redirects to this route with amount in POST/GET
        Route::match(['get', 'post'], 'initialize-deposit', [PaystackSubscriptionController::class, 'initializeWalletDeposit'])->name('initializeDeposit');
        Route::get('deposit-callback', [PaystackSubscriptionController::class, 'handleWalletDepositCallback'])->name('depositCallback');
    });
