# Paystack Payment Gateway Module

## Overview

This module integrates the Paystack payment gateway into the application, enabling subscription-based payments and one-time payments (if implemented).

## Features

- Paystack API integration for new subscriptions/payments.
- Management of Paystack API credentials (Public Key, Secret Key) via admin settings.
- Webhook handling for key Paystack events.

## Setup & Configuration

1.  **Install Dependencies (if any specific SDK is used later):**
    Currently uses direct HTTP calls. If you decide to use an official or third-party SDK:
    ```bash
    # composer require paystack/paystack-php (Example, check for official/recommended SDK)
    ```

2.  **Database Migrations:**
    *   The `subscription_plans` table should have a `paystack_plan_code` column to store the ID of the corresponding Plan created in your Paystack Dashboard.
    *   Run module migrations: `php artisan module:migrate PaystackGateway`

3.  **Environment Variables (Fallback):**
    While settings are managed via the admin panel, you can have fallback values in your main `.env` file:
    ```env
    PAYSTACK_PUBLIC_KEY=your_test_public_key
    PAYSTACK_SECRET_KEY=your_test_secret_key
    ```
    Replace with your Live credentials for production after thorough testing.

4.  **Admin Configuration:**
    *   Navigate to `Admin Panel > Modules > Paystack Settings`.
    *   Enter your Paystack Public Key and Secret Key.
    *   Enable the Paystack Gateway.

5.  **Paystack Dashboard Setup:**
    *   **API Keys:** Obtain your Test and Live API keys (Public Key, Secret Key) from your Paystack Dashboard.
    *   **Plans:** For each subscription plan you offer, create a corresponding "Plan" in your Paystack Dashboard. Note the **Plan Code** for each. You will need to enter this code into the `paystack_plan_code` field when creating/editing subscription plans in your application's admin panel.
    *   **Webhook URL:**
        *   In your Paystack Dashboard (Settings > API Keys & Webhooks), add a Webhook URL.
        *   Set the "Webhook URL" to: `YOUR_APP_URL/webhooks/paystack` (e.g., `https://yourdomain.com/webhooks/paystack`). For local development, use a tunneling service like ngrok.
        *   Paystack sends all event types to your webhook URL. You'll filter them in your handler.

6.  **CSRF Exemption:**
    Ensure the Paystack webhook route (`webhooks/paystack`) is added to the `$except` array in `app/Http/Middleware/VerifyCsrfToken.php`.

## Webhook Handling

The module will need a controller and route to handle incoming webhooks from Paystack to update local subscription statuses. It's crucial that webhook signature verification is implemented for security.