<?php

use Illuminate\Support\Facades\Route;
use Modules\PaypalGateway\Http\Controllers\PaypalSubscriptionController;
use Modules\PaypalGateway\Http\Controllers\PaypalWebhookController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
*/

// Webhook - should generally be exempt from CSRF
Route::post('webhooks/paypal', [PaypalWebhookController::class, 'handleWebhook'])->name('webhooks.paypal.handle');

Route::middleware(['web', 'auth']) // User must be authenticated
     ->prefix('subscribe/paypal')
     ->name('subscription.paypal.')
     ->group(function () {
         // The {subscriptionPlan:slug} will use route model binding
         // Route::post('create-agreement/{subscriptionPlan:slug}', [PaypalSubscriptionController::class, 'createSubscription'])->name('create.subscription'); // Removed as main SubscriptionController handles initiation
         Route::get('execute-agreement', [PaypalSubscriptionController::class, 'executeSubscription'])->name('execute.subscription'); // Success
         Route::get('cancel-agreement', [PaypalSubscriptionController::class, 'cancelSubscriptionPage'])->name('cancel.subscription.page'); // User initiated cancel from PayPal
         Route::post('cancel-active', [PaypalSubscriptionController::class, 'cancelActiveSubscription'])->name('cancel.active'); // User cancels from app
     });

Route::middleware(['web', 'auth'])
    ->prefix('wallet/paypal')
    ->name('wallet.paypal.')
    ->group(function () {
        // The WalletController redirects to this route with amount in POST/GET
        Route::match(['get', 'post'], 'initialize-deposit', [PaypalSubscriptionController::class, 'initializeWalletDeposit'])->name('initializeDeposit');
        Route::get('deposit-callback', [PaypalSubscriptionController::class, 'handleWalletDepositCallback'])->name('depositCallback');
        Route::get('deposit-cancel', [PaypalSubscriptionController::class, 'handleWalletDepositCancel'])->name('depositCancel');
    });