@extends('layouts.admin') {{-- Use your admin layout --}}

@section('title', 'PayPal Gateway Settings')
@section('header_title', 'PayPal Gateway Configuration')

@section('content')
<div class="bg-white dark:bg-gray-800 overflow-hidden shadow-xl sm:rounded-lg">
    <div class="p-6 lg:p-8">
        <h1 class="text-2xl font-medium text-gray-900 dark:text-white mb-6">
            PayPal Settings
        </h1>

        @include('admin.partials.alerts') {{-- For success/error messages --}}

        <form action="{{ route('admin.paypalgateway.settings.update') }}" method="POST">
            @csrf
            @method('PUT')

            <div class="space-y-6">
                <!-- Enable PayPal -->
                <div>
                    @php
                        $id = 'paypal_enabled';
                        $name = 'paypal_enabled';
                        $label = 'Enable PayPal Gateway';
                        $value = '1';
                        $checked = old('paypal_enabled', $settings['paypal_enabled'] ?? '0') == '1';
                        $helpText = 'Toggle this to activate or deactivate the PayPal payment gateway.';
                    @endphp
                    <label for="{{ $id }}" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">{{ $label }}</label>
                    <label class="relative inline-flex items-center cursor-pointer mt-1">
                        <input type="checkbox" id="{{ $id }}" name="{{ $name }}" class="sr-only peer" value="{{ $value }}" {{ $checked ? 'checked' : '' }}>
                        <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-blue-300 dark:peer-focus:ring-blue-800 rounded-full peer dark:bg-gray-700 peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all dark:border-gray-600 peer-checked:bg-blue-600"></div>
                    </label>
                    @if($helpText)
                        <p class="mt-1 text-xs text-gray-500 dark:text-gray-400">{{ $helpText }}</p>
                    @endif
                    @error($name) <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                </div>

                <!-- PayPal Mode -->
                <div>
                    <label for="paypal_mode" class="block text-sm font-medium text-gray-700 dark:text-gray-300">PayPal Mode</label>
                    <select name="paypal_mode" id="paypal_mode" required
                            class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 focus:border-indigo-500 dark:focus:border-indigo-600 focus:ring-indigo-500 dark:focus:ring-indigo-600 rounded-md shadow-sm">
                        <option value="sandbox" {{ old('paypal_mode', $settings['paypal_mode'] ?? 'sandbox') == 'sandbox' ? 'selected' : '' }}>Sandbox (Testing)</option>
                        <option value="live" {{ old('paypal_mode', $settings['paypal_mode'] ?? '') == 'live' ? 'selected' : '' }}>Live (Production)</option>
                    </select>
                    @error('paypal_mode') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                </div>

                <!-- PayPal Client ID -->
                <div>
                    <label for="paypal_client_id" class="block text-sm font-medium text-gray-700 dark:text-gray-300">PayPal Client ID</label>
                    <input type="text" name="paypal_client_id" id="paypal_client_id" value="{{ old('paypal_client_id', $settings['paypal_client_id'] ?? '') }}"
                           class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 focus:border-indigo-500 dark:focus:border-indigo-600 focus:ring-indigo-500 dark:focus:ring-indigo-600 rounded-md shadow-sm">
                    @error('paypal_client_id') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                </div>

                <!-- PayPal Client Secret -->
                <div>
                    <label for="paypal_client_secret" class="block text-sm font-medium text-gray-700 dark:text-gray-300">PayPal Client Secret</label>
                    <input type="password" name="paypal_client_secret" id="paypal_client_secret" value="" {{-- Removed value for security --}}
                           class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 focus:border-indigo-500 dark:focus:border-indigo-600 focus:ring-indigo-500 dark:focus:ring-indigo-600 rounded-md shadow-sm"
                           placeholder="Leave blank to keep current secret">
                    <p class="text-xs text-gray-500 dark:text-gray-400 mt-1">Enter a new secret to update it. Leave blank to keep the existing one.</p>
                    @error('paypal_client_secret') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                </div>

                <!-- PayPal Webhook ID -->
                <div>
                    <label for="paypal_webhook_id" class="block text-sm font-medium text-gray-700 dark:text-gray-300">PayPal Webhook ID</label>
                    <input type="text" name="paypal_webhook_id" id="paypal_webhook_id" value="{{ old('paypal_webhook_id', $settings['paypal_webhook_id'] ?? '') }}"
                           class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 focus:border-indigo-500 dark:focus:border-indigo-600 focus:ring-indigo-500 dark:focus:ring-indigo-600 rounded-md shadow-sm">
                    <p class="text-xs text-gray-500 dark:text-gray-400 mt-1">Get this from your PayPal Developer Dashboard after creating a webhook.</p>
                    @error('paypal_webhook_id') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                </div>

            </div>

            <div class="mt-8 flex justify-end">
                <button type="submit"
                        class="inline-flex items-center px-4 py-2 bg-gray-800 dark:bg-gray-200 border border-transparent rounded-md font-semibold text-xs text-white dark:text-gray-800 uppercase tracking-widest hover:bg-gray-700 dark:hover:bg-white focus:bg-gray-700 dark:focus:bg-white active:bg-gray-900 dark:active:bg-gray-300 focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:ring-offset-2 dark:focus:ring-offset-gray-800 transition ease-in-out duration-150">
                    Save Settings
                </button>
            </div>
        </form>
    </div>
</div>
@endsection