<?php

namespace Modules\PaypalGateway\Providers;

use Illuminate\Support\ServiceProvider;
use Modules\PaypalGateway\Services\PaypalService; // Import the service
use Illuminate\Support\Facades\Blade;
use Nwidart\Modules\Traits\PathNamespace;

class PaypalGatewayServiceProvider extends ServiceProvider
{
    use PathNamespace;
    /**
     * @var string $moduleName
     */
    protected string $moduleName = 'PaypalGateway';

    /**
     * @var string $moduleNameLower
     */
    protected string $moduleNameLower = 'paypalgateway';

    /**
     * Boot the application events.
     *
     * @return void
     */
    public function boot(): void
    {
        $this->registerTranslations();
        $this->registerConfig();
        $this->registerViews();
        $this->loadMigrationsFrom(module_path($this->moduleName, 'Database/Migrations'));
        // Route loading is handled by the main app's RouteServiceProvider loop for modules.
        // $this->loadRoutesFrom(module_path($this->moduleName, 'Routes/web.php'));
        // $this->loadRoutesFrom(module_path($this->moduleName, 'Routes/admin.php'));
        // $this->loadRoutesFrom(module_path($this->moduleName, 'Routes/api.php'));
    }

    /**
     * Register the service provider.
     *
     * @return void
     */

    public function register(): void
    {
        $this->app->register(RouteServiceProvider::class); // It's good practice to register this

        $this->app->singleton(PaypalService::class, function ($app) {
            return new PaypalService();
        });
    }

    protected function registerConfig(): void
    {
        $this->publishes([
            module_path($this->moduleName, 'config/config.php') => config_path($this->moduleNameLower . '.php'),
        ], 'config');
        $this->mergeConfigFrom(
            module_path($this->moduleName, 'config/config.php'), $this->moduleNameLower
        );
    }

    public function registerViews(): void
    {
        $viewPath = resource_path('views/modules/'.$this->moduleNameLower);
        $sourcePath = module_path($this->moduleName, 'resources/views');

        $this->publishes([$sourcePath => $viewPath], ['views', $this->moduleNameLower.'-module-views']);

        $this->loadViewsFrom(array_merge($this->getPublishableViewPaths(), [$sourcePath]), $this->moduleNameLower);

        Blade::componentNamespace(config('modules.namespace').'\\' . $this->moduleName . '\\View\\Components', $this->moduleNameLower);
    }

    public function registerTranslations(): void
    {
        $langPath = resource_path('lang/modules/' . $this->moduleNameLower);

        if (is_dir($langPath)) {
            $this->loadTranslationsFrom($langPath, $this->moduleNameLower);
            $this->loadJsonTranslationsFrom($langPath);
        } else {
            $this->loadTranslationsFrom(module_path($this->moduleName, 'lang'), $this->moduleNameLower);
            $this->loadJsonTranslationsFrom(module_path($this->moduleName, 'lang'));
        }
    }

    public function provides(): array
    {
        return [];
    }

    private function getPublishableViewPaths(): array
    {
        $paths = [];
        foreach (config('view.paths') as $path) {
            if (is_dir($path.'/modules/'.$this->moduleNameLower)) {
                $paths[] = $path.'/modules/'.$this->moduleNameLower;
            }
        }

        return $paths;
    }
}