<?php

use Illuminate\Support\Facades\Route;
use Modules\PaynowGateway\Http\Controllers\PaynowSubscriptionController;
use Modules\PaynowGateway\Http\Controllers\PaynowWebhookController;

// Webhook route for Paynow notifications.
// This route should typically be exempt from CSRF protection.
Route::post('paynowgateway/webhook', [PaynowWebhookController::class, 'handleWebhook'])->name('paynowgateway.webhook');

Route::middleware(['web', 'auth']) // User must be authenticated
    ->prefix('subscribe/paynow')
    ->name('subscription.paynow.') // Matches main app's SubscriptionController redirection
    ->group(function () {
        // Route for initializing payment for a subscription plan
        Route::get('checkout/{subscriptionPlan:slug}', [PaynowSubscriptionController::class, 'initializeSubscriptionPayment'])->name('checkout');
        // Route for handling the callback from Paynow after payment attempt
        Route::match(['get', 'post'], 'callback', [PaynowSubscriptionController::class, 'handleSubscriptionCallback'])->name('callback');
        // Route for handling cancellation from Paynow page (if applicable)
        Route::get('cancel', [PaynowSubscriptionController::class, 'handleSubscriptionCancel'])->name('cancel');
    });

Route::middleware(['web', 'auth'])
    ->prefix('wallet/paynow')
    ->name('wallet.paynow.') // Matches main app's WalletController redirection
    ->group(function () {
        // Route for initializing a wallet deposit
        Route::get('initialize-deposit', [PaynowSubscriptionController::class, 'initializeWalletDeposit'])->name('initializeDeposit'); // WalletController redirects here with amount
        Route::match(['get', 'post'],'deposit-callback', [PaynowSubscriptionController::class, 'handleWalletDepositCallback'])->name('depositCallback');
        Route::get('deposit-cancel', [PaynowSubscriptionController::class, 'handleWalletDepositCancel'])->name('depositCancel');
    });