<?php

use Illuminate\Support\Facades\Route;
use Modules\PaynowGateway\Http\Controllers\Admin\PaynowConfigController;

// Routes are automatically prefixed with 'admin/paynowgateway' and named 'admin.paynowgateway.'
// by the main app's RouteServiceProvider for modules.
Route::middleware(['web', \App\Http\Middleware\IsAdminMiddleware::class]) // Ensure IsAdminMiddleware is correct
    ->group(function () {
        Route::get('settings', [PaynowConfigController::class, 'edit'])->name('settings.edit');
        Route::put('settings', [PaynowConfigController::class, 'update'])->name('settings.update');
    });