{{-- This is a placeholder. Similar to subscription checkout, Paynow might redirect. --}}
<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Deposit Funds with Paynow') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-lg mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-xl sm:rounded-lg p-6">
                <h3 class="text-lg font-medium text-gray-900">Deposit Amount: {{ $currency }} {{ number_format($amount, 2) }}</h3>

                @if (session('error'))
                    <div class="mb-4 p-4 text-sm text-red-700 bg-red-100 rounded-lg" role="alert">
                        {{ session('error') }}
                    </div>
                @endif

                <div class="mt-6">
                    <p class="text-gray-700">You will be redirected to Paynow to complete your deposit.</p>
                    <p class="mt-4 text-sm text-gray-500">If you are not redirected automatically, please <a href="{{ $redirectUrl ?? '#' }}" class="text-blue-600 hover:underline">click here</a>.</p>
                </div>
            </div>
        </div>
    </div>
    @if(isset($redirectUrl))
    <script>
        // Optional: Auto-redirect
        // window.location.href = "{{ $redirectUrl }}";
    </script>
    @endif
</x-app-layout>