{{-- This is a placeholder. Paynow might redirect to their hosted page. --}}
{{-- If Paynow uses an embedded form or SDK, you'll build that here. --}}
<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Subscribe to :planName via Paynow', ['planName' => $plan->name]) }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-xl sm:rounded-lg p-6">
                <h3 class="text-lg font-medium text-gray-900">Plan: {{ $plan->name }}</h3>
                <p class="mt-1 text-sm text-gray-600">Price: {{ $plan->currency }} {{ number_format($plan->price, 2) }} / {{ $plan->interval }}</p>

                @if (session('error'))
                    <div class="mb-4 p-4 text-sm text-red-700 bg-red-100 rounded-lg" role="alert">
                        {{ session('error') }}
                    </div>
                @endif

                <div class="mt-6">
                    <p class="text-gray-700">You will be redirected to Paynow to complete your payment.</p>
                    {{--
                        If Paynow requires a form to be submitted to their endpoint,
                        you would build that form here with the necessary hidden fields
                        populated by $paymentDetails from your controller.

                        Example:
                        <form action="{{ $redirectUrl ?? '#' }}" method="POST">
                            @foreach($formFields ?? [] as $name => $value)
                                <input type="hidden" name="{{ $name }}" value="{{ $value }}">
                            @endforeach
                            <button type="submit" class="btn btn-primary">Proceed to Paynow</button>
                        </form>
                    --}}
                    <p class="mt-4 text-sm text-gray-500">If you are not redirected automatically, please <a href="{{ $redirectUrl ?? '#' }}" class="text-blue-600 hover:underline">click here</a>.</p>
                </div>
            </div>
        </div>
    </div>
    @if(isset($redirectUrl))
    <script>
        // Optional: Auto-redirect if JavaScript is enabled
        // window.location.href = "{{ $redirectUrl }}";
    </script>
    @endif
</x-app-layout>