@extends('layouts.admin')

@section('title', 'Paynow Gateway Settings')
@section('header_title', 'Paynow Gateway Settings')

@section('content')
<div class="bg-white dark:bg-gray-800 overflow-hidden shadow-xl sm:rounded-lg">
    <div class="p-6 lg:p-8">
        @include('admin.partials.alerts')

        <form action="{{ route('admin.paynowgateway.settings.update') }}" method="POST">
            @csrf
            @method('PUT')

            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <!-- Enable Paynow -->
                <div class="md:col-span-2">
                    <x-admin.toggle-switch id="paynowgateway_enabled" name="paynowgateway_enabled" label="Enable Paynow Gateway"
                                           :checked="old('paynowgateway_enabled', $settings['paynowgateway_enabled'] ?? '0') == '1'"
                                           helpText="Toggle to activate or deactivate the Paynow payment gateway." />
                    @error('paynowgateway_enabled') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                </div>

                <!-- Paynow Mode -->
                <div>
                    <label for="paynow_mode" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Paynow Mode</label>
                    <select name="paynow_mode" id="paynow_mode" required
                            class="mt-1 block w-full pl-3 pr-10 py-2 text-base border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-100 focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm rounded-md">
                        <option value="test" {{ old('paynow_mode', $settings['paynow_mode'] ?? 'test') == 'test' ? 'selected' : '' }}>Test/Sandbox</option>
                        <option value="live" {{ old('paynow_mode', $settings['paynow_mode'] ?? '') == 'live' ? 'selected' : '' }}>Live</option>
                    </select>
                    @error('paynow_mode') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                </div>
                <div></div> {{-- Spacer --}}

                <!-- Paynow Integration ID -->
                <div>
                    <label for="paynow_integration_id" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Integration ID</label>
                    <input type="text" name="paynow_integration_id" id="paynow_integration_id" value="{{ old('paynow_integration_id', $settings['paynow_integration_id'] ?? '') }}"
                           class="mt-1 block w-full shadow-sm sm:text-sm border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-100 rounded-md focus:ring-indigo-500 focus:border-indigo-500">
                    @error('paynow_integration_id') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                </div>

                <!-- Paynow Integration Key -->
                <div>
                    <label for="paynow_integration_key" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Integration Key</label>
                    <input type="password" name="paynow_integration_key" id="paynow_integration_key" value="{{ old('paynow_integration_key', $settings['paynow_integration_key'] ?? '') }}"
                           class="mt-1 block w-full shadow-sm sm:text-sm border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-100 rounded-md focus:ring-indigo-500 focus:border-indigo-500">
                    @error('paynow_integration_key') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                </div>

                <!-- Paynow Webhook Secret (if applicable) -->
                <div>
                    <label for="paynow_webhook_secret" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Webhook Secret (if applicable)</label>
                    <input type="password" name="paynow_webhook_secret" id="paynow_webhook_secret" value="{{ old('paynow_webhook_secret', $settings['paynow_webhook_secret'] ?? '') }}"
                           class="mt-1 block w-full shadow-sm sm:text-sm border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-100 rounded-md focus:ring-indigo-500 focus:border-indigo-500">
                    @error('paynow_webhook_secret') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                </div>
            </div>

            <div class="mt-8 flex justify-end">
                <button type="submit" class="inline-flex items-center px-4 py-2 bg-gray-800 dark:bg-gray-200 border border-transparent rounded-md font-semibold text-xs text-white dark:text-gray-800 uppercase tracking-widest hover:bg-gray-700 dark:hover:bg-white focus:bg-gray-700 dark:focus:bg-white active:bg-gray-900 dark:active:bg-gray-300 focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:ring-offset-2 dark:focus:ring-offset-gray-800 transition ease-in-out duration-150">
                    Save Settings
                </button>
            </div>
        </form>
    </div>
</div>
@endsection