<?php

namespace Modules\PaynowGateway\Database\Seeders;

use Illuminate\Database\Seeder;
    use App\Models\Setting; // Assuming your Setting model is in App\Models

class PaynowGatewayDatabaseSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
            $settings = [
                [
                    'key' => 'paynowgateway_enabled',
                    'value' => '0', // Default to disabled
                    'name' => 'Enable Paynow Gateway',
                    'group' => 'Payment Gateways',
                    'type' => 'checkbox',
                    'description' => 'Enable or disable the Paynow payment gateway.'
                ],
                [
                    'key' => 'paynow_integration_id',
                    'value' => '',
                    'name' => 'Paynow Integration ID',
                    'group' => 'Payment Gateways',
                    'type' => 'text',
                    'description' => 'Your Paynow Integration ID provided by Paynow.'
                ],
                [
                    'key' => 'paynow_integration_key',
                    'value' => '',
                    'name' => 'Paynow Integration Key',
                    'group' => 'Payment Gateways',
                    'type' => 'password',
                    'description' => 'Your Paynow Integration Key provided by Paynow.'
                ],
                [
                    'key' => 'paynow_mode',
                    'value' => 'test',
                    'name' => 'Paynow Mode',
                    'group' => 'Payment Gateways',
                    'type' => 'select', // View should render options: {"test": "Test/Sandbox", "live": "Live"}
                    'description' => 'Set Paynow to Test/Sandbox or Live mode.'
                ],
                [
                    'key' => 'paynow_webhook_secret',
                    'value' => '',
                    'name' => 'Paynow Webhook Secret (for hash verification)',
                    'group' => 'Payment Gateways',
                    'type' => 'password',
                    'description' => 'The secret key used to verify incoming Paynow webhooks.'
                ],
            ];
    
            foreach ($settings as $settingData) {
                // Check if the setting already exists to prevent overriding user-configured values
                $existingSetting = Setting::where('key', $settingData['key'])->first();
                if (!$existingSetting) {
                    Setting::create([
                        'key' => $settingData['key'],
                        'value' => $settingData['value'],
                        'name' => $settingData['name'],
                        'group' => $settingData['group'],
                        'type' => $settingData['type'],
                        'description' => $settingData['description'] ?? null,
                    ]);
                }
            }
    }
}
