<?php

namespace Modules\PaynowGateway\Providers;

use App\Models\SubscriptionPlan; // Import your SubscriptionPlan model
use Illuminate\Foundation\Support\Providers\RouteServiceProvider as ServiceProvider;
use Illuminate\Support\Facades\Route;

class RouteServiceProvider extends ServiceProvider
{
    protected string $name = 'PaynowGateway';
    protected string $moduleNamespace = 'Modules\PaynowGateway\Http\Controllers';

    /**
     * Called before routes are registered.
     *
     * Register any model bindings or pattern based filters.
     */
    public function boot(): void
    {
        parent::boot();

        // Explicitly bind the 'subscriptionPlan' route parameter if used in this module's routes
        // to resolve SubscriptionPlan models by 'slug' without global scopes.
        Route::bind('subscriptionPlan', function ($value) {
            return SubscriptionPlan::where((new SubscriptionPlan)->getRouteKeyName(), $value)
                ->withoutGlobalScopes()
                ->firstOrFail();
        });
    }

    /**
     * Define the routes for the application.
     */
    public function map(): void
    {
        $this->mapAdminRoutes();
        $this->mapApiRoutes();
        $this->mapWebRoutes();
    }

    /**
     * Define the "admin" routes for the module.
     *
     * These routes are typically protected by admin-specific middleware.
     * They are prefixed with '/admin/paynowgateway' and named with 'admin.paynowgateway.'.
     */
    protected function mapAdminRoutes(): void
    {
        Route::middleware(['web', \App\Http\Middleware\IsAdminMiddleware::class])
             ->prefix('admin/' . strtolower($this->name)) // e.g., admin/paynowgateway
             ->name('admin.' . strtolower($this->name) . '.')     // e.g., admin.paynowgateway.
             // If your admin controllers are in an 'Admin' sub-namespace (e.g., Modules\PaynowGateway\Http\Controllers\Admin)
             // and you are NOT using full namespaces in your admin.php routes, uncomment the line below.
             // ->namespace($this->moduleNamespace . '\\Admin')
             ->group(module_path($this->name, '/routes/admin.php'));
    }

    /**
     * Define the "web" routes for the application.
     *
     * These routes all receive session state, CSRF protection, etc.
     */
    protected function mapWebRoutes(): void
    {
        Route::middleware('web')
            // ->namespace($this->moduleNamespace) // Uncomment if your web controllers are not fully namespaced
            ->group(module_path($this->name, '/routes/web.php')); // Standardized path
    }

    /**
     * Define the "api" routes for the application.
     *
     * These routes are typically stateless.
     */
    protected function mapApiRoutes(): void
    {
        Route::middleware('api')
            ->prefix('api') // Global API prefix
            ->name('api.')   // Global API route name prefix
            // ->namespace($this->moduleNamespace . '\\Api') // Uncomment if API controllers are in an 'Api' sub-namespace and not fully namespaced
            ->group(module_path($this->name, '/routes/api.php')); // Standardized path
    }
}
