<?php

use Illuminate\Support\Facades\Route;
use Modules\LandingPage\Http\Controllers\PublicPageController; // For listing pages and generic LpPages
use Modules\LandingPage\Http\Controllers\FrontendController; // For single item detail pages

/*
|--------------------------------------------------------------------------
| Web Routes for LandingPage Module
|--------------------------------------------------------------------------
*/

// Listing Pages (handled by PublicPageController)
Route::get('/jobs', [PublicPageController::class, 'showJobs'])->name('landingpage.jobs.index');
Route::get('/products', [PublicPageController::class, 'showProducts'])->name('landingpage.products.index');
Route::get('/tenders', [PublicPageController::class, 'showTenders'])->name('landingpage.tenders.index');
Route::get('/companies', [PublicPageController::class, 'showCompanies'])->name('landingpage.companies.index');
Route::get('/company-projects', [PublicPageController::class, 'showCompanyProjects'])->name('landingpage.company-projects.index');
Route::get('/portfolio', [PublicPageController::class, 'showPortfolioProjects'])->name('landingpage.portfolio.index');
Route::get('/news', [PublicPageController::class, 'showNews'])->name('landingpage.news.index'); // Assuming a general news listing page

// Single Item Detail Pages (handled by FrontendController)
Route::get('/jobs/{slug}', [FrontendController::class, 'showJob'])->name('landingpage.jobs.show');
Route::get('/companies/{slug}', [FrontendController::class, 'showCompany'])->name('landingpage.companies.show');
Route::get('/products/{slug}', [FrontendController::class, 'showProduct'])->name('landingpage.products.show');
Route::get('/tenders/{slug}', [FrontendController::class, 'showTender'])->name('landingpage.tenders.show');
Route::get('/news/{slug}', [FrontendController::class, 'showNewsArticle'])->name('landingpage.news.show');

// "View All" pages for specific company's items (handled by FrontendController)
Route::get('/company/{company_slug}/products', [
    FrontendController::class, 'showCompanyProducts'
])->name('theme.company.products');
Route::get('/company/{company_slug}/jobs', [
    FrontendController::class, 'showCompanyJobs'
])->name('theme.company.jobs');
Route::get('/company/{company_slug}/tenders', [
    FrontendController::class, 'showCompanyTenders'
])->name('theme.company.tenders');


Route::get('/{slug?}', [PublicPageController::class, 'showPage'])->where('slug', '^(?!api\/|admin\/|nova-api\/|telescope\/|horizon\/|livewire\/|_ignition\/|_debugbar\/)[a-zA-Z0-9-_\/.]*$')->name('landingpage.page.show');
