<?php

use Illuminate\Support\Facades\Route;
use Modules\LandingPage\Http\Controllers\Admin\LpPageController;
use Modules\LandingPage\Http\Controllers\Admin\ThemeSettingController;
use Modules\LandingPage\Http\Controllers\Admin\MenuController; 
use Modules\LandingPage\Http\Controllers\Admin\MenuItemController; 
use Modules\LandingPage\Http\Controllers\Admin\PageSectionController;

// Page Management
Route::resource('pages', LpPageController::class);

// Theme Settings
Route::get('theme-settings', [ThemeSettingController::class, 'edit'])->name('theme.settings.edit');
Route::put('theme-settings', [ThemeSettingController::class, 'update'])->name('theme.settings.update');

// Menu Management
Route::resource('menus', MenuController::class); 
Route::post('menus/{menu}/items', [MenuItemController::class, 'store'])->name('menus.items.store');
Route::put('menus/{menu}/items/{item}', [MenuItemController::class, 'update'])->name('menus.items.update');
Route::delete('menus/{menu}/items/{item}', [MenuItemController::class, 'destroy'])->name('menus.items.destroy');
Route::post('menus/{menu}/items/reorder', [MenuItemController::class, 'reorder'])->name('menus.items.reorder');
    
// Page Section Management (Nested under pages)
Route::prefix('pages/{page}/sections')->name('pages.sections.')->group(function () {
    Route::get('create', [PageSectionController::class, 'create'])->name('create');
    Route::post('', [PageSectionController::class, 'store'])->name('store');
    Route::get('{section}/edit', [PageSectionController::class, 'edit'])->name('edit');
    Route::put('{section}', [PageSectionController::class, 'update'])->name('update');
    Route::delete('{section}', [PageSectionController::class, 'destroy'])->name('destroy');
});
 
