@php
    // $section is available from the page renderer
    // Default values for section content
    $sectionTitle = $section->content['title'] ?? 'Featured Companies';
    $numberOfCompanies = (int)($section->content['number_of_items'] ?? 4);
    $displayType = $section->content['display_type'] ?? 'featured'; // 'featured' or 'latest'
    $viewAllLink = $section->content['view_all_link'] ?? null; // e.g., '/companies'
    $viewAllText = $section->content['view_all_text'] ?? 'View All Companies';

    // Fetch companies from BusinessDirectory module
    try {
        $companiesQuery = \Modules\BusinessDirectory\Entities\Company::query()
            ->where('status', 'approved'); // Assuming 'approved' or 'active' is the status for visible companies

        if ($displayType === 'featured') {
            $companiesQuery->where('is_featured', true);
        }

        $companies = $companiesQuery
            ->orderBy('created_at', 'desc') // Or by name, or a specific order field
            ->take($numberOfCompanies)
            ->get();
    } catch (\Throwable $e) {
        $companies = collect();
        \Illuminate\Support\Facades\Log::error("Error fetching companies for landing page section: " . $e->getMessage());
    }
@endphp

@if($companies->isNotEmpty())
<section class="py-12 md:py-20 bg-gray-100 dark:bg-gray-900">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8">
        <h2 class="text-3xl font-bold text-center text-gray-800 dark:text-white mb-10">{{ $sectionTitle }}</h2>
        <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-8">
            @foreach($companies as $company)
                <div class="bg-white dark:bg-gray-800 p-6 rounded-lg shadow-lg hover:shadow-xl transition-shadow duration-300 flex flex-col items-center text-center">
                    @if($company->logo)
                        <img src="{{ Storage::url($company->logo) }}" alt="{{ $company->name }} Logo" class="w-24 h-24 object-contain rounded-full mb-4 border border-gray-200 dark:border-gray-700">
                    @else
                        <div class="w-24 h-24 bg-gray-200 dark:bg-gray-700 rounded-full mb-4 flex items-center justify-center border border-gray-200 dark:border-gray-700">
                            <span class="text-gray-500 dark:text-gray-400 text-sm">No Logo</span>
                        </div>
                    @endif
                    <h3 class="text-xl font-semibold text-[var(--clr-accent)] mb-2 flex-grow">{{ $company->name }}</h3>
                    <p class="text-gray-600 dark:text-gray-400 text-sm mb-3">{{ Str::limit($company->description ?? 'Leading company in its field.', 70) }}</p>
                    <a href="{{-- route('module.companies.show', $company->slug) --}}#" class="mt-auto inline-block text-purple-500 hover:text-purple-700 dark:hover:text-purple-300 font-medium text-sm">View Profile &rarr;</a>
                </div>
            @endforeach
        </div>
        @if($viewAllLink)
        <div class="text-center mt-12">
            <a href="{{ url($viewAllLink) }}" class="inline-block bg-purple-600 hover:bg-purple-700 text-white font-semibold py-3 px-8 rounded-lg transition duration-300">
                {{ $viewAllText }}
            </a>
        </div>
        @endif
    </div>
</section>
@endif