@extends('landingpage::themes.job_board.layouts.app') {{-- Crucial: Extends THEME'S app layout --}}

{{-- The $page object is passed from FrontendController and used by the extended layout for meta tags --}}
{{-- You can override specific meta tags here if needed for this specific template --}}
{{-- @section('meta_title', $company->name . ' - Company Details - ' . setting('site_name')) --}}

@section('content')
    <div class="container mx-auto px-4 py-8">
        <article class="bg-white dark:bg-slate-800 shadow-xl rounded-lg p-6 md:p-8">
            <header class="mb-6">
                <h1 class="text-3xl md:text-4xl font-bold text-slate-900 dark:text-slate-100">{{ $company->name }}</h1>
                {{-- Add more company details here like tagline, location etc. if available --}}
            </header>

            <div class="prose dark:prose-invert max-w-none">
                {!! $company->description !!} {{-- Make sure this is properly sanitized if it contains user-generated HTML --}}
            </div>
            {{-- Add more sections: jobs by this company, contact info, map, etc. --}}
        </article>
    </div>
@endsection